/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.Application;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FocusMeta;
import com.queplix.core.client.app.vo.SubFocusMeta;
import com.queplix.core.client.app.vo.TabMeta;
import com.queplix.core.client.common.event.EventSource;
import com.queplix.core.client.common.ui.resizable.ResizableLazyDeckPanel;
import com.queplix.core.client.controls.grid.QGrid;

import java.util.ArrayList;

/**
 * Postfix GA - Grid Area.
 * On sub focus change you should select corresponding SubFocusGA in this class to show correct contents.
 * Class MainFrameGA contains array of FocusGA.
 * This class FocusGA contains array of SubFocusGA.
 * Class SubFocusGA contains array of TabGA.
 * Class TabGA contains array of QGrid.
 *
 * @author Aliaksandr Melnik
 * @since 19 Oct 2006
 */
class FocusGA extends ResizableLazyDeckPanel {

    // -------------------- public events ------------------------
    public static interface Events extends SubFocusGA.Events {
    }

    private EventSource eventSource = new EventSource(this);

    public EventSource getEventSource() {
        return eventSource;
    }
    // ----------------- end of public events --------------------

    private ArrayList gridListeners = new ArrayList();
    private SubFocusGA[] subFocusesGA;
    private SubFocusMeta[] subFocusesMeta;
    private String status;

    public FocusGA(FocusMeta focusMeta) {
        super(focusMeta.getSubFocuses().length);
        status = Application.getStatus();

        subFocusesMeta = focusMeta.getSubFocuses();
        subFocusesGA = new SubFocusGA[subFocusesMeta.length];

        if(subFocusesMeta.length > 0) {
            showWidget(0);
        }
    }

    public SubFocusGA[] getSubFocusesGA() {
        return subFocusesGA;
    }

    public void performCommand(GridCommand command, FamgMeta.Index formID) {
        subFocusesGA[formID.subFocus].performCommand(command, formID);
    }

    protected void createCard(int index) {
        subFocusesGA[index] = new SubFocusGA(subFocusesMeta[index]);
        subFocusesGA[index].getEventSource().addEventListener(eventSource); // retranslate events
        remove(index);
        insert(subFocusesGA[index], index);
    }

    void activateSubFocus(SubFocusMeta.Index index) {
        showWidget(index.subFocus);
    }

    void activateTab(TabMeta.Index index) {
        activateSubFocus(index);
        subFocusesGA[index.subFocus].activateTab(index);
    }

    void activateGrid(FamgMeta.Index index) {
        activateSubFocus(index);
        subFocusesGA[index.subFocus].activateGrid(index);
    }

    public SubFocusMeta.Index getSelectedSubFocusIndex() {
        return subFocusesMeta[getVisibleWidget()].getIndex();
    }

    public TabMeta.Index getSelectedTabIndex() {
        return subFocusesGA[getVisibleWidget()].getSelectedTabIndex();
    }

    public FamgMeta.Index getSelectedFormIndex() {
        return subFocusesGA[getVisibleWidget()].getSelectedFormIndex();
    }

    public void clearAllGrids() {
        for (int i = 0; i < subFocusesGA.length; i++) {
            if(subFocusesGA[i] != null) {
                subFocusesGA[i].clearAllGrids();
            }
        }
    }

    QGrid getGrid(FamgMeta.Index famgIndex) {
        SubFocusGA subFocusGA = subFocusesGA[famgIndex.subFocus];
        return subFocusGA != null ? subFocusGA.getGrid(famgIndex) : null;
    }

    FamgMeta.Index getActiveGridIndex() {
        int activeSubFocus = getVisibleWidget();
        FamgMeta.Index index = subFocusesGA[activeSubFocus].getActiveGridIndex();
        index.subFocus = activeSubFocus;
        return index;
    }

    void collectUISettings() {
        for (int i = 0; i < subFocusesGA.length; i++) {
            if(subFocusesGA[i] != null) {
                subFocusesGA[i].collectUISettings();
            }
        }
    }
}
