/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.frames.mainframe.impl;

import com.google.gwt.user.client.ui.Widget;
import com.queplix.core.client.common.event.Event;
import com.queplix.core.client.common.ui.ButtonData;
import com.queplix.core.client.common.ui.EventButtonData;
import com.queplix.core.client.common.ui.Icon;
import com.queplix.core.client.common.ui.IconButton;
import com.queplix.core.client.common.ui.IconData;
import com.queplix.core.client.common.ui.ToolBar;

/**
 * MainFrame Tool Bar.
 * @author Sultan Tezadov
 * @since 10 Oct 2006
 */
class MainToolBar extends ToolBar {
    
    // -------------------- public events ------------------------
    public static interface Events {
        Event BACK = new Event();
        Event FORWARD = new Event();
        Event CLEAR_ALL = new Event();
        Event LAST_SEARCH = new Event();
        Event LAST_SEARCH_MENU = new Event();
        Event LOAD_SAVED_SEARCH = new Event();
        Event SAVE_CURRENT_SEARCH = new Event();
        Event PRINT_FORM = new Event();
        //Event PRINT_GRID = new Event();
        Event E_MAIL = new Event();
        Event BROADCAST = new Event();
        Event ALERTS = new Event();
        Event AD_HOC_REPORTS = new Event();
        Event REPORT_SCHEDULER = new Event();
        Event SAVE_SETTINGS = new Event();
    }
    // ----------------- end of public events --------------------
    
    public static interface Indicator {
        ButtonData IDLE = new ButtonData(null, "Idle", "toolbar/indicator_idle.gif");
        ButtonData COMMUNICATING = new ButtonData(null, "Communicating", "toolbar/indicator_communicating.gif");
        ButtonData WORKING = new ButtonData(null, "Working", "toolbar/indicator_working.gif");
    }
    
    private static interface Buttons {
        ButtonData BACK = new ButtonData(null, "Back", "toolbar/back.gif", "toolbar/back_disabled.gif", "toolbar/back_bright.gif");
        ButtonData FORWARD = new ButtonData(null, "Forward", "toolbar/forward.gif", "toolbar/forward_disabled.gif", "toolbar/forward_bright.gif");
        ButtonData CLEAR_ALL = new ButtonData(null, "Clear All", "toolbar/clear_all.gif", null, "toolbar/clear_all_bright.gif");
        ButtonData LAST_SEARCH = new ButtonData(null, "Last Search", "toolbar/last_search.gif", "toolbar/last_search_disabled.gif", "toolbar/last_search_bright.gif");
        ButtonData LAST_SEARCH_MENU = new ButtonData(null, "Last Search Options", "toolbar/button_menu.gif", null, "toolbar/button_menu_bright.gif");
        ButtonData LOAD_SAVED_SEARCH = new ButtonData("Load Saved Search");
        ButtonData SAVE_CURRENT_SEARCH = new ButtonData("Save Current Search");
        ButtonData PRINT_FORM = new ButtonData(null, "Print Form", "toolbar/print_form.gif", "toolbar/print_form_disabled.gif", "toolbar/print_form_bright.gif");
        ButtonData PRINT_GRID = new ButtonData(null, "Print Grid", "toolbar/print_grid.gif", "toolbar/print_grid_disabled.gif", "toolbar/print_grid_bright.gif");
        ButtonData E_MAIL = new ButtonData(null, "E-mail", "toolbar/e_mail.gif", null, "toolbar/e_mail_bright.gif");
        ButtonData BROADCAST = new ButtonData(null, "Broadcasts", "toolbar/broadcast.gif", null, "toolbar/broadcast_bright.gif");
        ButtonData ALERTS = new ButtonData(null, "Alerts", "toolbar/alerts.gif", null, "toolbar/alerts_bright.gif");
        ButtonData AD_HOC_REPORTS = new ButtonData(null, "Ad-Hoc Report Designer", "toolbar/ad_hoc_reports.gif", null, "toolbar/ad_hoc_reports_bright.gif");
        ButtonData REPORT_SCHEDULER = new ButtonData(null, "Report Scheduler", "toolbar/report_scheduler.gif", null, "toolbar/report_scheduler_bright.gif");
        ButtonData SAVE_SETTINGS = new ButtonData(null, "Save Settings", "toolbar/save_settings.gif", null, "toolbar/save_settings_bright.gif");
    }
    
    private Icon indicator;
    
    public MainToolBar() {
        IconData divider = new IconData("toolbar_divider", null, true);
        addIcon(new IconData("toolbar/logo_company.gif", null), true);
        addIcon(divider, true);
        addButton(Events.BACK, Buttons.BACK, true);
        addButton(Events.FORWARD, Buttons.FORWARD, true);
        addIcon(divider, true);
        addButton(Events.CLEAR_ALL, Buttons.CLEAR_ALL, true);
        IconButton button = addButton(Events.LAST_SEARCH, Buttons.LAST_SEARCH, true);
        IconButton menuButton = addMenuButton(Events.LAST_SEARCH_MENU, Buttons.LAST_SEARCH_MENU, true,
                new EventButtonData[] {
                    new EventButtonData(Events.LOAD_SAVED_SEARCH, Buttons.LOAD_SAVED_SEARCH),
                    new EventButtonData(Events.SAVE_CURRENT_SEARCH, Buttons.SAVE_CURRENT_SEARCH)
        });
        mergeButtons(button, menuButton);
        addIcon(divider, true);
        addButton(Events.PRINT_FORM, Buttons.PRINT_FORM, true);
        //addButton(Events.PRINT_GRID, Buttons.PRINT_GRID, true);
        addIcon(divider, true);
        addButton(Events.E_MAIL, Buttons.E_MAIL, true);
        addIcon(divider, true);
/*        addButton(Events.BROADCAST, Buttons.BROADCAST, true);
        addButton(Events.ALERTS, Buttons.ALERTS, true);
        addIcon(divider, true);*/
        addButton(Events.AD_HOC_REPORTS, Buttons.AD_HOC_REPORTS, true);
//        addButton(Events.REPORT_SCHEDULER, Buttons.REPORT_SCHEDULER, true);
        addIcon(divider, true);
        addButton(Events.SAVE_SETTINGS, Buttons.SAVE_SETTINGS, true);
        addIcon(divider, true);
        indicator = addIcon(Indicator.IDLE, true);
        ButtonData logoData = new ButtonData(null, "http://www.queplix.com", "common/queweb_logo.gif");
        addButton(com.queplix.core.client.frames.mainframe.Events.OPEN_QUEPLIX_SITE, logoData, false);
    }
    
    public void setIndicatorState(ButtonData state){
        indicator.setIconState(state);
    }
    
}
