/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/*
 * MainTree.java
 *
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FocusMeta;
import com.queplix.core.client.app.vo.FormMeta;
import com.queplix.core.client.app.vo.MetaData;
import com.queplix.core.client.app.vo.SubFocusMeta;
import com.queplix.core.client.app.vo.TabMeta;
import com.queplix.core.client.controls.tree.QTree;
import com.queplix.core.client.controls.tree.QTreeNode;
import com.queplix.core.client.controls.tree.QTreeNodeListener;
import com.queplix.core.client.common.event.EventSource;
import com.queplix.core.client.common.event.Event;
import java.util.Map;
import java.util.HashMap;

/**
 *
 * @author aliaksandr.melnik
 */
class MainTree extends QTree {
    public static final Integer FOCUS = new Integer(0);
    public static final Integer SUBFOCUS = new Integer(1);
    public static final Integer TAB = new Integer(2);
    public static final Integer FORM = new Integer(3);

    private Map typesMap = new HashMap();

    // -------------------- public events ------------------------
    public static interface Events {
        Event/*]<FocusMeta.Index>[*/ FOCUS_SELECTED = new Event/*]<FocusMeta.Index>[*/();
        Event/*]<SubFocusMeta.Index>[*/ SUBFOCUS_SELECTED = new Event/*]<SubFocusMeta.Index>[*/();
        Event/*]<TabMeta.Index>[*/ TAB_SELECTED = new Event/*]<TabMeta.Index>[*/();
        Event/*]<FamgMeta.Index>[*/ FORM_SELECTED = new Event/*]<FamgMeta.Index>[*/();
    }

    private EventSource eventSource;

    public EventSource getEventSource() {
        return eventSource;
    }
    // ----------------- end of public events --------------------

    public MainTree(MetaData appMetaData) {
        eventSource = new EventSource(getView());

        QTreeNode node = getModel().getRoot();
        FocusMeta[] focuses = appMetaData.getFocuses();
        for (int i=0; i < focuses.length; i++) {
            FocusMeta focus = focuses[i];
            QTreeNode subNode = new QTreeNode(focus.getCaption(), focus.getIndex(), focus.getIcon());
            typesMap.put(focus.getIndex(), FOCUS);
            node.addChild(subNode);
            SubFocusMeta[] subFocuses = focus.getSubFocuses();
            for (int j=0; j < subFocuses.length; j++) {
                SubFocusMeta subFocus = subFocuses[j];
                QTreeNode subNode2 = new QTreeNode(subFocus.getCaption(), subFocus.getIndex(), subFocus.getIcon());
                typesMap.put(subFocus.getIndex(), SUBFOCUS);
                subNode.addChild(subNode2);
                TabMeta[] tabs = subFocus.getTabs();
                for (int k=0; k < tabs.length; k++) {
                    TabMeta tab = tabs[k];
                    QTreeNode subNode3 = new QTreeNode(tab.getCaption(), tab.getIndex(), tab.getIcon());
                    typesMap.put(tab.getIndex(), TAB);
                    subNode2.addChild(subNode3);
                    FamgMeta[] famgMeta = tab.getFamgs();
                    for (int m=0; m < famgMeta.length; m++) {
                        FormMeta form = famgMeta[m].getForm();
                        QTreeNode subNode4 = new QTreeNode(form.getCaption(), form.getIndex(), form.getIcon());
                        typesMap.put(form.getIndex(), FORM);
                        subNode3.addChild(subNode4);
                    }
                }
            }
        }
        getView().setRootNodeHidden(true);
        getView().expandRootChildren();
        getView().refresh();
//        getView().expandAll();
        
        getController().addNodeListener(new QTreeNodeListener() {
            public void onQTreeNodeSelected(QTreeNode node) {
                Integer type = (Integer) typesMap.get(node.getId());
                switch (type.intValue()) {
                    case 0: {
                        Events.FOCUS_SELECTED.setData(node.getId());
                        eventSource.fireEventGeneratedByUser(Events.FOCUS_SELECTED);
                        break;
                    }
                    case 1: {
                        Events.SUBFOCUS_SELECTED.setData(node.getId());
                        eventSource.fireEventGeneratedByUser(Events.SUBFOCUS_SELECTED);
                        break;
                    }
                    case 2: {
                        Events.TAB_SELECTED.setData(node.getId());
                        eventSource.fireEventGeneratedByUser(Events.TAB_SELECTED);
                        break;
                    }
                    case 3: {
                        Events.FORM_SELECTED.setData(node.getId());
                        eventSource.fireEventGeneratedByUser(Events.FORM_SELECTED);
                        break;
                    }
                }
            }
        });
    }
}
