/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.vo.GridData;
import com.queplix.core.client.app.vo.RowData;

/**
 * Implements command, that should tell grid to set data.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 16:29:43
 */
class SetDataForGridCommand extends GridCommand {
    private final static int COMMAND_TYPE = SET_GRID_DATA;
    private GridData data;
    private int totalRecordsCount = -1;
    private int currentPage = 0;

    public SetDataForGridCommand(GridData data, int totalRecordsCount, int currentPage) {
        super(COMMAND_TYPE);
        this.totalRecordsCount = totalRecordsCount;
        this.currentPage = currentPage;
        if(data == null) {
            this.data = new GridData(new RowData[0], "");
        } else {
            this.data = data;
        }
    }

    public SetDataForGridCommand(GridData data) {
        this(data, -1, 0);
    }

    public SetDataForGridCommand() {
        this(null);
    }

    /**
     * Return value could not be null object
     * @return grid data
     */
    public GridData getData() {
        return data;
    }

    public void setData(GridData data) {
        if(data != null) {
            this.data = data;
        }
    }
    
    public int getTotalRecordsCount() {
        return totalRecordsCount;
    }

    public int getCurrentPage() {
        return currentPage;
    }
    
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

}
