/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.vo.RowData;

/**
 * Implements command, that should tell specified grid row to set data.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 16:29:43
 */
class SetDataForRowCommand extends GridCommand {
    private final static int COMMAND_TYPE = SET_ROW_DATA;
    private RowData data;

    public SetDataForRowCommand(RowData data) {
        super(COMMAND_TYPE);
        if(data == null) {
            this.data = new RowData(new Long(-1), new String[0]);
        } else {
            this.data = data;
        }
    }

    public SetDataForRowCommand() {
        this(null);
    }

    /**
     * Return value could not be null object
     * @return grid row data
     */
    public RowData getData() {
        return data;
    }

    public void setData(RowData data) {
        if(data != null) {
            this.data = data;
        }
    }
}
