/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.frames.mainframe.impl;

import com.queplix.core.client.app.vo.FieldOnDemandData;

/**
 * Implements command, that should tell form to set data.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 16:29:43
 */
class SetOnDemandDataForControlCommand extends FormCommand {
    private final static int COMMAND_TYPE = SET_ON_DEMAND_CONTROL_DATA;
    private FieldOnDemandData data;

    public SetOnDemandDataForControlCommand(FieldOnDemandData data) {
        super(COMMAND_TYPE);
        this.data = data;
    }

    public SetOnDemandDataForControlCommand() {
        this(null);
    }

    public FieldOnDemandData getData() {
        return data;
    }

    public void setData(FieldOnDemandData data) {
        this.data = data;
    }
}
