/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.frames.mainframe.impl;

/**
 * Implements the command, that should tell form to set specified "update" status.
 *
 * @author Sergey Kozmin
 * @since 31.10.2006, 16:29:43
 */
class SetUpdateStatusFormCommand extends FormCommand {
    private final static int COMMAND_TYPE = SET_UPDATE_STATUS;
    /**
     * one of {@link com.queplix.core.client.controls.form.QFormModel#UPDATE_SUCCESSFUL}
     */
    private int updateState;

    /**
     * Contruct the command with the given update status.
     * @param updateState one of {@link com.queplix.core.client.controls.form.QFormModel#UPDATE_SUCCESSFUL}
     */
    public SetUpdateStatusFormCommand(int updateState) {
        super(COMMAND_TYPE);
        this.updateState = updateState;
    }

    public int getUpdateState() {
        return updateState;
    }
}
