/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.i18n;

/**
 * Internationalized messages.
 * @author Sultan Tezadov
 * @since 11 Dec 2006
 */
public interface Messages extends com.google.gwt.i18n.client.Messages {
    String welcomeUserMessage();
    String invalidFieldFormat();
    String requiredField();
    String incorrectControlData();
    String couldNotSelectRecord();
    String deleteRecordWarning();
    String customizeGrid();
    String addRemoveGridColumns();
    String selectAll();
    String deselectAll();
    String clearAll();
    String invert();
    String invertSelection();
    String atLeastOneColumnShouldBeSelected();
    String saveSearch();
    String enterTheName();
    String enterNewName();
    String newSt();
    String loadSavedSearch();
    String searchName();
    String focus();
    String refreshGrid();
    String applicationCloseConfirmationShort();
    String applicationCloseConfirmationLong();
    String exportToWord();
    String exportToExcel();
    String uiSettingsSavedSucc();
    String loginSuccess();
    String canNotOpenFormNewMode();
    String printGrid();
    String searchSaved();
    String searchError();
    String delete();

    //adhoc messages
    String adhocReportLoaded();
    String adhocSaveReport();
    String adhocFieldName();
    String adhocReportName();
    String adhocNewFieldName();
    String adhocFillFieldFirstError();
    String adhocRenameColumnButton();
    String adhocRenameColumnButtonTooltip();
    String adhocFillReportFirstError();
    String adhocClearAllColumnButton();
    String adhocClearAllColumnButtonTooltip();
    String adhocRunReportButton();
    String adhocRunReportButtonTooltip();
    String adhocDeleteColumnButton();
    String adhocDeleteColumnButtonTooltip();
    String adhocSaveReportButton();
    String adhocSaveReportButtonTooltip();
    String adhocLoadReportButton();
    String adhocLoadReportButtonTooltip();
    String adhocMoveColumnToLeftButtonTooltip();
    String adhocMoveColumnToRightButtonTooltip();
    String adhocNoneReportName();
    String adhocReportsSavedSuccesfully();
    String adhocLoadReportDialogTitle();
    String adhocAvailableReportsLabel();
    String adhocdDeleteReportButton();
    String adhocdDeleteReportButtonTooltip();
    String adhocReportIncorrectWarning();

    String enterLoginAndPassword();
    String login();
    String password();
    String copyrightText();
    String privacyStatement();
    String searchDeleted();
    String deleteSearchItem();
    String searchNameExistsOverwrite();
    
    //qgrid
    String gridRecordsPage();
    String gridCounter();
    String gridTotalRecords();
    String gridLoaded();
    String gridPageSizePositiveMessage();

    // dialogs
    String yes();
    String no();
    String cancel();
    String logOff();
    String ok();

    // Charts
    String chartsBarChartLabel();
    String chartsPieChartLabel();
    String chartsFilterByDateLabel();
    String chartsRefreshLabel();

    String searchNameEmpty();
    String cantSaveSearch();

    //qform
    String formDiscardChanges(String formTitle);
    String noPermissionsToDeleteRecord();

    //email dialog
    String emailExitConfirmation();
    String emailDialogCaption();
    String emailSendFailed();
    String emailActivateRecordFirst();
    String emailAttachmentDialogCaption();
    String emailEmptyFields();
    
    //memo
    String memoHTMLtoPlaintextConfirmation();
}
