/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.integrator;

import com.queplix.core.integrator.entity.RequestProperties;
import com.queplix.core.integrator.security.LogonSession;

/**
 * Base request builder
 *
 * @author Sergey Kozmin
 * @since 04.04.2007
 */
abstract class BaseRequestBuilder implements RequestBuilder {
    protected String requestingEntityName;
    protected RequestProperties props;
    protected LogonSession ls;
    protected ActionContext ctx;

    public BaseRequestBuilder(
            LogonSession ls, RequestProperties props, ActionContext ctx,
            String requestingEntityName) {
        this.ls = ls;
        this.props = props;
        this.ctx = ctx;
        this.requestingEntityName = requestingEntityName;
    }
}
