/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.services.www;

import com.queplix.core.modules.services.ServiceInitManager;
import com.queplix.core.modules.services.ServiceStartupManager;
import com.queplix.core.utils.www.AbstractServlet;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

/**
 * <p><b>Automatically starts scheduler</b></p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1 $ $Date: 2006/04/18 12:04:16 $
 */

public class SchedulerServlet
    extends AbstractServlet {

    //
    // Init method (start scheduler)
    //
    public void init( ServletConfig cfg )
        throws ServletException {

        super.init( cfg );

        logger.DEBUG( "Scheduler servlet started..." );

        ServiceInitManager sim = new ServiceInitManager();
        boolean autostart = sim.getSchedulerAutostart();

        if( autostart ) {
            boolean error = false;
            try {
                ServiceStartupManager.startScheduler( -1, -1L );
            } catch( Throwable t ) {
                error = true;
                logger.ERROR( t );
            }

            if( error ) {
                logger.DEBUG( "Scheduler servlet completed with errors..." );
            } else {
                logger.DEBUG( "Scheduler servlet successfully completed..." );
            }
        } else {
            logger.DEBUG( "Skip process..." );
        }
    }
}
