/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.modules.web.www;

import com.queplix.core.utils.SystemHelper;
import com.queplix.core.utils.www.AbstractFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;

/**
 * <p>Catch response and set cache headers</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:31:04 $
 */
public class CacheContentFilter
    extends AbstractFilter {

    private static final boolean isProdMode = SystemHelper.isProductionMode();

    /**
     * Do filter
     * @param request HTTP request
     * @param response HTTP response
     * @param chain FilterChain object
     * @throws IOException
     * @throws ServletException
     */
    public void doFilter( ServletRequest request, ServletResponse response, FilterChain chain )
        throws IOException, ServletException {

        if( isProdMode ) {
            // Set headers for response
            HttpServletResponse res = ( HttpServletResponse ) response;

            Enumeration e = filterConfig.getInitParameterNames();
            while( e.hasMoreElements() ) {
                String headerName = ( String ) e.nextElement();
                res.setHeader( headerName, filterConfig.getInitParameter( headerName ) );
            }

            // [ALB] old realization
            // res.setHeader( "Cache-Control", "public, max-age=" + Integer.MAX_VALUE );
        }

        // Do chain filter
        chain.doFilter( request, response );
    }
}
