/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.tools.fkchecker.client;

import com.queplix.tools.fkchecker.client.handlers.SourcesComparer;

/**
 * @author dmitry.antonov
 */
public class Main {

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                throw new IllegalArgumentException("usage:\nutil source1.properties source2.properties");
            }
            SourcesComparer comparer = new SourcesComparer(args[0], args[1]);
            comparer.compareSources();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

}
