/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.installer;

import com.izforge.izpack.event.SimpleUninstallerListener;
import com.izforge.izpack.util.AbstractUIProgressHandler;

import java.io.*;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

/**
 * @author dmitry.antonov
 */
public class QuewebUninstallerListener extends SimpleUninstallerListener {

    private static final String UNINSTALLER_PROPERTIES = "uninstallerProperties.xml";


    private void exec(String command) {
        try {
            Process proc = Runtime.getRuntime().exec(command);
            InputStream stderr = proc.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            while (br.readLine() != null) {
            }
            proc.waitFor();
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void uninstallServices(File propertiesFile, AbstractUIProgressHandler handler) throws IOException {
        int step = 1;
        handler.progress(step++, "Removing installed NT services...");
        Properties properties = new Properties();
        properties.loadFromXML(new FileInputStream(propertiesFile));
        if (properties.getProperty("installScheduler").equals("service")) {
            handler.progress(step++, "Stopping and removing QueWeb Scheduler Service");
            exec("\"" + properties.getProperty("INSTALL_PATH") + "\\Scheduler\\scheduler_service.bat remove");
        }
        if (properties.getProperty("installMySQL").equals("yes")) {
            handler.progress(step++, "Stopping MySQL service...");
            exec("net stop MySQL");
            handler.progress(step++, "Removing MySQL service...");
            exec("\"" + properties.getProperty("MYSQL_PATH") + "\\bin\\mysqld.exe\" --remove");
        }
        if (properties.getProperty("INSTALL_SERVICE").equals("yes")) {
            handler.progress(step++, "Stopping QueWeb service...");
            exec("net stop QueWeb");
            handler.progress(step++, "Removing QueWeb service...");
            exec("cmd /C \"" + properties.getProperty("JBOSS_PATH") + "\\bin\\UninstallQueWeb-NT.bat\"");
            handler.progress(step++, "Done");
        }
    }


    /*
    * (non-Javadoc)
    *
    * @see com.izforge.izpack.uninstaller.UninstallerListener#beforeDeletion(java.util.List,
    * com.izforge.izpack.util.AbstractUIProgressHandler)
    */
    public void beforeDeletion(List files, AbstractUIProgressHandler handler) throws Exception {
        for (Iterator iterator = files.iterator(); iterator.hasNext();) {
            File file = (File) iterator.next();
            if (file.getName().equals(UNINSTALLER_PROPERTIES)) {
                uninstallServices(file, handler);
                return;
            }
        }
    }

}
