DELIMITER //

-- use qwoss
-- //

DELETE FROM QW_FIELDINFO
//

/*admin employee*/
INSERT INTO QW_EMPLOYEE (qw_employeeid,qw_userid,qw_firstname,qw_lastname,qw_fullname) VALUES (0,0,'Administrator','Admin','Admin, Administrator')
//

/*ticket statuses*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,0,'New')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,1,'Assigned')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,2,'Owned')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,3,'Release Candidate')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,4,'Delivered')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,5,'Un-reproducible')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,6,'Client Issue')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,7,'Duplicate')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,8,'Parked')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,9,'Test Fail')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_status',14,10,'Closed')
//

INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation','qw_fireif',14,0,'Not Closed')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation','qw_fireif',14,1,'Not Updated')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation','qw_fireif',14,2,'Not Assigned')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation','qw_timeunit',14,0,'Minutes')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation','qw_timeunit',14,1,'Hours')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation','qw_timeunit',14,2,'Days')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation','qw_timeunit',14,3,'Work Days')
//

/*ticket escalation recipients*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_recipient','qw_recipient',14,0,'Escalation Workgroup')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_recipient','qw_recipient',14,1,'Escalation Employee')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_recipient','qw_recipient',14,2,'Escalation Email')
//

/*ticket escalation priority*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_priority','qw_priority',14,0,'Critical')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_priority','qw_priority',14,1,'Serious')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_priority','qw_priority',14,2,'Moderate')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_priority','qw_priority',14,3,'Low')
//

/*ticket escalation statuss*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,0,'New')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,1,'Assigned')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,2,'Owned')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,3,'Release Candidate')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,4,'Delivered')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,5,'Un-reproducible')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,6,'Client Issue')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,7,'Duplicate')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,8,'Parked')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,9,'Test Fail')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketescalation_status','qw_status',14,10,'Closed')
//

INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_priority','qw_priority',14,0,'Critical')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_priority','qw_priority',14,1,'Serious')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_priority','qw_priority',14,2,'Moderate')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_priority','qw_priority',14,3,'Low')
//


INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,0,'New')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,1,'Assigned')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,2,'Owned')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,3,'Release Candidate')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,4,'Delivered')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,5,'Un-reproducible')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,6,'Client Issue')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,7,'Duplicate')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,8,'Parked')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,9,'Test Fail')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_status','qw_status',14,10,'Closed')
//


/*ticket priorities*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_priority',14,0,'1-Critical')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_priority',14,1,'2-Serious')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_priority',14,2,'3-Moderate')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_priority',14,3,'4-Low')
//

/*ticket impacts*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_impact',14,0,'All Sites')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_impact',14,1,'System Down')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_impact',14,2,'Site')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_impact',14,3,'Group')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_impact',14,4,'Individual')
//

/*ticket types*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_type',14,0,'BUG')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_type',14,1,'RFE')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_type',14,2,'INFO')
//

/*ticket sources*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_source',14,0,'Email')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_source',14,1,'Phone')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_source',14,2,'Fax')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_source',14,3,'Voice Mail')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_source',14,4,'Walkup')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_source',14,5,'Self')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_source',14,6,'Other')
//

/*ticket responses*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_response',14,0,'Email')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_response',14,1,'Phone')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_response',14,2,'Fax')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_response',14,3,'Voice Mail')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_response',14,4,'Walkup')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticket','qw_response',14,5,'Self')
//

/*ticket reasons*/
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,0,'Training Issue')
//
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,1,'Patch/Upgrade')
//
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,2,'Configuration Issue')
//
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,3,'Correct Behaviour')
//
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,4,'Documentation Error')
//
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,5,'Insufficient Evidence')
//
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,6,'Product Limitation')
//
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,7,'Support Expired')
//
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,8,'Withdrawn')
//
INSERT INTO QW_FIELDINFO VALUES ('qw_ticket','qw_reasoncallid',14,9,'Other')
//

/*address types*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_address','qw_addresstype',14,0,'Primary')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_address','qw_addresstype',14,1,'Secondary')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_address','qw_addresstype',14,2,'Mailing')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_address','qw_addresstype',14,3,'Billing')
//

/*reach by*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_employee','qw_reachby',14,0,'Email')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_employee','qw_reachby',14,1,'Phone')
//


/*interaction source*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_interaction','qw_source',14,0,'Incoming Call')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_interaction','qw_source',14,1,'Outgoing Call')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_interaction','qw_source',14,2,'Fax')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_interaction','qw_source',14,3,'Incoming Email')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_interaction','qw_source',14,4,'Outgoing Email')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_interaction','qw_source',14,5,'Walk-up')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_interaction','qw_source',14,6,'Other')
//

/* interaction action taken */
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_interaction','qw_action',14,0,'Ticket Linked')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_interaction','qw_action',14,1,'Resolved By Agent')
//

/*ticket notification send modes*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification','qw_sendmode',14,0,'Alert')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification','qw_sendmode',14,1,'Email')
//

/*ticket notification recipients*/
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_recip','qw_recipient',14,0,'Workgroup')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_recip','qw_recipient',14,1,'Use Email To Address')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_recip','qw_recipient',14,2,'Agent')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_recip','qw_recipient',14,3,'Owner')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_ticketnotification_recip','qw_recipient',14,4,'Ticket Customer')
//

/* solution topics */
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_topic',14,0,'Hardware')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_topic',14,1,'Software')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_topic',14,2,'Product')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_topic',14,3,'Service')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_topic',14,4,'Documentation')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_topic',14,5,'Operation')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_topic',14,6,'Network')
//

/* workflow */
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_workflow','qw_objecttype',14,0,'Solution')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_workflow','qw_objecttype',14,1,'Ticket')
//

/* solution status */
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_solutionstatus',14,0,'Draft')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_solutionstatus',14,1,'Reviewed')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_solutionstatus',14,2,'Published')
//
INSERT INTO QW_FIELDINFO (qw_tablename,qw_columnname,qw_columntype,qw_enumvalue,qw_enumlabel) VALUES ('qw_solution','qw_solutionstatus',14,3,'Retired')
//


/*event type*/
insert into QW_EVENTTYPE (qw_eventid, qw_eventtype) values (0, 'Ticket Created')
//
insert into QW_EVENTTYPE (qw_eventid, qw_eventtype) values (1, 'Status Change')
//
insert into QW_EVENTTYPE (qw_eventid, qw_eventtype) values (2, 'Priority Change')
//
insert into QW_EVENTTYPE (qw_eventid, qw_eventtype) values (3, 'Impact Change')
//
insert into QW_EVENTTYPE (qw_eventid, qw_eventtype) values (4, 'Type Change')
//
insert into QW_EVENTTYPE (qw_eventid, qw_eventtype) values (5, 'Agent Change')
//
insert into QW_EVENTTYPE (qw_eventid, qw_eventtype) values (6, 'Owner Change')
//
insert into QW_EVENTTYPE (qw_eventid, qw_eventtype) values (7, 'Workgroup Change')
//


/*default values*/
insert into QX_USERS (pkey,loginname,fullname,user_type) values (-1000,'defemp','DEFAULT_EMPLOYEE',0)
//
insert into QW_EMPLOYEE (qw_employeeid,qw_userid,qw_firstname,qw_lastname,qw_fullname) values (-1000,-1000,'DEFAULT','EMPLOYEE','DEFAULT_EMPLOYEE')
//
insert into QW_PRODUCT (qw_productid,qw_name) values (-1000,'DEFAULT_PRODUCT')
//
insert into QW_BUILDVERSION (qw_buildid,qw_name,qw_version,qw_productid) values (-1000,'DEFAULT_VERSION','0.0.0.0',-1000)
//
insert into QW_CUSTOMER (qw_customerid,qw_lastname,qw_firstname,qw_fullname) values (-1000,'CUSTOMER','UNKNOWN','Unknown Customer')
//
CALL QX_NEXT_KEY('qx_sys_prop', 1, @id)
//
insert into QX_SYS_PROP values (@id,'UNKNOWN_CUSTOMER','-1000',NULL,NULL,0,'Default ticket customer  Primary Key of the Customer record used in Tickets where Customer cannot be identified (i.e. ticket created from unknown email.')
//
CALL QX_NEXT_KEY('qx_sys_prop', 1, @id)
//
insert into QX_SYS_PROP values (@id,'DEFAULT_AGENT','-1000',NULL,NULL,0,'Default ticket agent  Primary Key of the Agent used in Tickets where Agent cannot be identified.')
//

/*QX_SCRIPT*/
CALL QX_NEXT_KEY('qx_script', 1, @id)
//
insert into QX_SCRIPT(SCRIPT_ID, SCRIPT_NAME, SCRIPT_DESCRIPTION, SCRIPT_CLASS_NAME, CREATOR_ID, DATE_MODIFIED) values(@id, 'Solutions Retire', 'Retires expired solutions', 'com.queplix.qwoss.actions.RetireSolutionsAction', 0, curdate())
//
CALL QX_NEXT_KEY('QX_SCRIPT', 1, @id)
//
insert into QX_SCRIPT(SCRIPT_ID, SCRIPT_NAME, SCRIPT_DESCRIPTION, SCRIPT_CLASS_NAME, CREATOR_ID, DATE_MODIFIED) values(@id, 'Escalations', 'Sends escalations', 'com.queplix.qwoss.notification.EscalationAction', 0, curdate())
//
CALL QX_NEXT_KEY('QX_SCRIPT', 1, @id)
//
insert into QX_SCRIPT(SCRIPT_ID, SCRIPT_NAME, SCRIPT_DESCRIPTION, SCRIPT_CLASS_NAME, CREATOR_ID, DATE_MODIFIED) values(@id, 'Send reports', 'Reports scheduler. Send user''s reports via e-mail', 'com.queplix.core.modules.eqlext.actions.SendReportsAction', 0, curdate())
//


CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_TICKET_STATUS', '0', 'Email processing - default ticket status', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_TICKET_PRIORITY', '1', 'Email processing - default ticket priority', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_TICKET_TYPE', '0', 'Email processing - default ticket type', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_TICKET_SOURCE', '1', 'Email processing - default ticket source', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_TICKET_IMPACT', '1', 'Email processing - default ticket impact', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_TICKET_OWNER', '1', 'Email processing - default ticket owner', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_INTER_SOURCE', '3', 'Interaction email filter source field', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_INTER_DEFAULT_AGENT', '-1000', 'Default Email agent  Primary Key of the Agent used in Email processing.', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_TICKET_RVERSION', '-1000', 'Default Ticket Repbuild Version  used in Email processing.', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_TICKET_AGENT', '0', 'Default Ticket Agent  used in Email processing.', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_TICKET_PRODUCT', '-1000', 'Default Ticket Product  used in Email processing.', 1)
//

insert into QX_FIELDINFO values ('qx_inbox', 'object_type', 14, 1, 'Interaction')
//
insert into QX_FIELDINFO values ('qx_inbox', 'object_type', 14, 2, 'Ticket')
//
insert into QX_FIELDINFO values ('qx_inbox', 'object_type', 14, 3, 'Solution')
//
insert into QX_FIELDINFO values ('qx_inbox', 'object_type', 14, 4, 'Message')
//

CALL QX_NEXT_KEY('QX_TASK', 1, @id)
//
select script_id into @idScript from qx_script where script_name = 'Inbox'
//
insert into QX_TASK (task_id, task_name, task_status_id, script_id, creator_id, date_created, first_start, next_start, delay, task_delayunit_id, repeat_sign)
  values(@id, 'email_proc', 1, @idScript, 0, curdate(), curdate(), curdate(), 1, 0, 1)
//

CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_DEFAULT_CUSTOMER_NAME', 'Email processing', 'Default Customer name  used in Email processing.', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'IN_EMAIL_DEFAULT_CUSTOMER_ID', '-1000', 'Default Customer ID  used in Email processing.', 1)
//
CALL QX_NEXT_KEY('QX_SYS_PROP', 1, @id)
//
insert into QX_SYS_PROP (PKEY, PROP_ID, PROP_VAL, DESCRIPTION, NEED_RESTART) values (@id, 'OUT_EMAIL_INTER_SOURCE', '1', 'Default Customer name  used in Email processing.', 1)
//