/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.eql.funcs;

import com.queplix.core.modules.eql.EQLNumberObject;
import com.queplix.core.modules.eql.EQLReqFuncExecutable;
import com.queplix.core.modules.eql.EQLReqSubOpMember;
import com.queplix.core.modules.eql.EQLReqSubOpMemberFunc;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.qwoss.gen.EmployeeObject;
import com.queplix.qwoss.utils.ApplicationHelper;

/**
 * <p>Employee Id Function Implementation</p>
 * 
 * 
 */

public final class EmployeeIdFunc
    extends EQLReqSubOpMemberFunc
    implements EQLReqFuncExecutable {

    // process
    public EQLReqSubOpMember execute()
        throws EQLException {
        Object obj = eqlInt.getSession().getLogonSession().getParameter(ApplicationHelper.EMPLOYEE_KEY);
        if(obj == null || !(obj instanceof EmployeeObject))
            throw new EQLException("Can't retrieve Employee Id.\nInvalid parameter for key: "+ApplicationHelper.EMPLOYEE_KEY);
        EmployeeObject employeeObj = (EmployeeObject) obj;
        return new EQLNumberObject( employeeObj.getQw_employeeid() );
    }
}
