/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.gen;

import java.util.List;
import com.queplix.core.modules.jeo.gen.UserObject;
import com.queplix.core.modules.jeo.gen.UserObjectHandler;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObject;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;

/**
 * Employee JEO handler.
 *
 * @author [LIV] Ladnev Ilya
 * @version $Revision: 1.2 $ $Date: 2006/06/04 00:15:09 $
 */
public class EmployeeObjectHandler
    extends JEObjectHandler {

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return "employee";
    }

    /* (non-Javadoc)
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return EmployeeObject.class;
    }

    // ============================================================= EQL methods

    public static UserObject selectUserByEmployeeID( JEOManagerLocal manager, LogonSession ls, long id )
    throws EQLException {
        String eql = "select users.* where employee.qw_employeeid = " + id;
        List hndList = manager.select( ls, UserObjectHandler.class, eql );

        if(hndList == null)
            return null;

        JEObject jeo = ((JEObjectHandler) hndList.get(0)).getJEObject();
        return (UserObject) jeo;
    }
    
    /**
     * Gets employee by user ID (unique key).
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param userID user ID to search by
     * @return EmployeeObject, or <code>null</code> if none found
     * @throws EQLException
     */
    public static EmployeeObject selectByUserID( JEOManagerLocal manager, LogonSession ls, long id )
        throws EQLException {

        String eql = "select employee.* where employee.qw_userid = " + id;

        List hndList = manager.select( ls, EmployeeObjectHandler.class, eql );

        if(hndList == null)
            return null;

        JEObject jeo = ((JEObjectHandler) hndList.get(0)).getJEObject();
        return (EmployeeObject) jeo;
    }
    
    public static Long selectOrgByID( EQLManagerLocal eqlManager, LogonSession ls, long id )
        throws EQLException {

        String eql = "select employee.qw_orgid where employee.qw_employeeid = " + id;
        EQLRes eqlRes = eqlManager.select( ls, eql );
        if(eqlManager.selectCount( ls, eqlRes ) > 0) 
            return eqlRes.getRecord(0).getResCell(0).getLong();
        else 
            return null;
    }

    public static String selectMailByID( EQLManagerLocal eqlManager, LogonSession ls, long id )
        throws EQLException {

        String eql = "select employee.qw_email where employee.qw_employeeid = " + id;
        EQLRes eqlRes = eqlManager.select( ls, eql );

        if(eqlManager.selectCount( ls, eqlRes ) > 0)
            return eqlRes.getRecord(0).getResCell(0).getString();
        else
            return null;
    }

    public static Long selectIDByEmail(EQLManagerLocal eqlManager, LogonSession ls, String emailAddress)
        throws EQLException {

        String eql = "select employee.qw_employeeid where employee.qw_email = '" + emailAddress + "'";
        EQLRes eqlRes = eqlManager.select(ls, eql);

        if (eqlManager.selectCount(ls, eqlRes ) > 0)
            return eqlRes.getRecord(0).getResCell(0).getLong();
        else
            return null;
    }

}
