/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.gen;

import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import java.util.List;
import com.queplix.core.integrator.security.LogonSession;

/**
 * escalation Priority Fields JEO handler.
 * 
 * @version $Revision$ $Date$
 */
public class EscPriorityFieldObjectHandler extends JEObjectHandler {

    // ======================================================= Inherited methods

    /*
     * (non-Javadoc)
     * 
     * @see JEObjectHandler#getEntityName()
     */
    public String getEntityName() {
        return "ticketescalation_priority";
    }

    /*
     * (non-Javadoc)
     * 
     * @see JEObjectHandler#getObjectClass()
     */
    public Class getObjectClass() {
        return EscPriorityFieldObject.class;
    }

    /**
     * Select by ID
     * 
     * @param local JEOManager local interface
     * @param ls    user logon session
     * @param id    Escalation Id
     * @return object or NULL
     * @throws EQLException
     */
    public static List selectByEscalationId(JEOManagerLocal local,
            LogonSession ls, Long id) throws EQLException {
        if(id == null)
            return null;
        List hndList = local.select(ls, EscPriorityFieldObjectHandler.class,
                "SELECT ticketescalation_priority.* WHERE ticketescalation_priority.qw_escalationid = " + id);
        return hndList;
    }
}
