/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.gen;

import java.util.Date;

import com.queplix.core.modules.jeo.JEObject;

/**
 * Interaction JEO interface.
 * 
 * @version $Revision: 1.2 $ $Date: 2005/12/27 10:05:30 $ 
 */
public interface InteractionObject extends JEObject {

    Long getQw_interactionid();
    Integer getQw_source();
    String getQw_problem();
    String getQw_description();
    Long getQw_agentid();
    Long getQw_customerid();
    Long getQw_employeeid();
    Long getQw_phonetime();
    Long getQw_researchtime();
    Long getQw_modifiedbyid();
    Date getQw_datemodified();
    Date getQw_datereceived();
    char[] getQw_notes();

    boolean isNullQw_source();
    boolean isNullQw_customerid();
    boolean isNullQw_employeeid();
    boolean isNullQw_phonetime();
    
    void setQw_interactionid(Long l);
    void setQw_source(Integer i);
    void setQw_problem(String s);
    void setQw_description(String s);
    void setQw_agentid(Long l);
    void setQw_customerid(Long l);
    void setQw_employeeid(Long l);
    void setQw_phonetime(Long l);
    void setQw_researchtime(Long l);
    void setQw_modifiedbyid(Long l);
    void setQw_datemodified(Date d);
    void setQw_notes(char[] s);
}