/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.gen;

import com.queplix.core.modules.eql.EQLObject;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.parser.EQLIntPreparedStatement;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.utils.DateHelper;

import com.queplix.qwoss.utils.SolutionHelper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/**
 * Description.
 *
 * @author Sergei Savchuk
 */
public class SolutionObjectHandler extends JEObjectHandler {
    public static final String ENTITY = "solution.knowledge_base";

    /* (non-Javadoc)
     * @see JEObjectHandler.getEntityName()
     */
    public String getEntityName() {
        return ENTITY;
    }

    /* (non-Javadoc)
     * @see JEObjectHandler.getObjectClass()
     */
    public Class getObjectClass() {
        return SolutionObject.class;
    }

    /**
     * Selects solutions ready to be retired.
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @return List of solutions
     * @throws EQLException
     */
    public static List selectSolutionsToRetire(JEOManagerLocal manager, LogonSession ls) 
    throws EQLException {
        
        String eql = "select solution.knowledge_base.* where solution.knowledge_base.qw_dateexpiration < ? and solution.knowledge_base.qw_solutionstatus != ?";
        EQLIntPreparedStatement stat = new EQLIntPreparedStatement();
        stat.setObject(1, EQLObject.getInstance(DateHelper.getNowDate()));
        stat.setObject(2, EQLObject.getInstance(SolutionHelper.RETIRED_STATUS));

        List hndList = manager.select(ls, SolutionObjectHandler.class, stat, eql);
        if(hndList == null)
            return null;

        List solutions = new ArrayList();
        for (Iterator iter = hndList.iterator(); iter.hasNext();) {
            JEObjectHandler hnd = (JEObjectHandler) iter.next();
            solutions.add( (SolutionObject)hnd.getJEObject() );
        }
        return solutions;
    }

}
