/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.gen;

import java.util.List;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;

/**
 * <p>Ticket Escalation JEO handler</p>
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.3 $ $Date: 2005/08/17 09:28:50 $
 */
public class TicketEsclEventObjectHandler
    extends JEObjectHandler {

    /**
     * Get entity name
     * @return entity name
     */
    public String getEntityName() {
        return "escalation_event";
    }

    /**
     * Get JEO object class
     * @return class
     */
    public Class getObjectClass() {
        return TicketEsclEventObject.class;
    }

    /**
     * Select by PKEY
     * @param local JEOManager local interface
     * @param ls user logon session
     * @param pkey PKEY
     * @return object or NULL
     * @throws EQLException
     */
    public static JEObjectHandler selectByPkey( JEOManagerLocal local, LogonSession ls, long pkey )
        throws EQLException {
        List hndList = local.select( ls, TicketEsclEventObjectHandler.class, "SELECT escalation_event.* WHERE escalation_event.qw_esceventid = " + pkey );
        if( hndList == null ) {
            return null;
        } else {
            return( JEObjectHandler ) hndList.get( 0 );
        }
    }

    /**
     * Select by escalation Id and ticket Id
     * @param local JEOManager local interface
     * @param ls user logon session
     * @param escalationId escalation Id
     * @param ticketId ticket Id
     * @return List of objects or NULL
     * @throws EQLException
     */
    public static List selectByEscalationAndTicket( JEOManagerLocal local,
                                                  LogonSession ls,
                                                  Long escalationId,
                                                  Long ticketId )
        throws EQLException {

        StringBuffer eql = new StringBuffer();
        eql.append( "SELECT escalation_event.* WHERE " );
        eql.append( "escalation_event.qw_escalationid = " ).append( escalationId );
        eql.append( " AND " ).append( "escalation_event.qw_ticketid = " ).append( ticketId );

        return local.select( ls, TicketEsclEventObjectHandler.class, eql.toString() );
    }

    /**
     * Select matured escalation events
     * @param local JEOManager local interface
     * @param ls user logon session
     * @return List of objects or NULL
     * @throws EQLException
     */
    public static List selectMatured( JEOManagerLocal local,
                                      LogonSession ls )
        throws EQLException {

        StringBuffer eql = new StringBuffer();
        eql.append( "SELECT escalation_event.* WHERE " );
        eql.append( "escalation_event.qw_next_check < now()" );

        return local.select( ls, TicketEsclEventObjectHandler.class, eql.toString() );
    }
}
