/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.gen;

import com.queplix.core.modules.jeo.JEObject;

import java.util.Date;

/**
 * Description.
 * @author rustem.nizamiev
 * @since 18 January 2007, 15:41
 */
public interface TicketObject extends JEObject {
    
    Long getQw_ticketid();
    Integer getQw_status();
    Integer getQw_priority();
    Integer getQw_type();
    Integer getQw_source();
    Integer getQw_impact();
    Integer getQw_category();
    Integer getQw_subcategory();
    Integer getQw_reasoncode();

    String getQw_response();    
    String getQw_problem();
    String getQw_action();
    String getQw_description();
    
    Long getQw_solution();
    Long getQw_agentid();
    Long getQw_workgroupid();
    Long getQw_ownerid();
    //Integer getQw_qw_escworkgroupid();
    Long getQw_modifiedbyid();
    
    Date getQw_datereported();
    Date getQw_dateassigned();
    Date getQw_dateowned();
    Date getQw_dateresolved();
    Date getQw_daterequested();
    Date getQw_eta();
    Date getQw_datedelivered();
    Date getQw_dateclosed();
    //Date getQw_lastescalated();
    Date getQw_lastreopened();
    Date getQw_laststatuschanged();
    Date getQw_datemodified();
    Date getQw_holdtilldate();
    
    //Long getQw_phonetime();
    //Long getQw_researchtime();
    Integer getQw_reopencnt();

    Long getQw_productid();
    Long getQw_componentid();
    Long getQw_repbuildversionid();
    Long getQw_resbuildversionid();
    Long getQw_repenvironmentid();
    Long getQw_testenvironmentid();
    Long getQw_customerid();
    Long getQw_employeeid();
    
    Integer getQw_callage();
    
    char[] getQw_intcomments();
    char[] getQw_notes();
    char[] getQw_history();
    char[] textQw_history();
    char[] getQw_descriptiontext();
    char[] getQw_responsetext();

    String textQw_ownerid();
    String textQw_agentid();
    String textQw_workgroupid();
    String textQw_status();
    String textQw_priority();
    String textQw_type();
    String textQw_impact();
    
    Integer oldQw_status();
    String oldTextQw_status();
    Long oldQw_ownerid();
    String oldTextQw_ownerid();
    Integer oldQw_priority();
    String oldTextQw_priority();
    Integer oldQw_type();
    String oldTextQw_type();
    Integer oldQw_impact();
    String oldTextQw_impact();
    Long oldQw_agentid();
    String oldTextQw_agentid();
    Long oldQw_workgroupid();
    String oldTextQw_workgroupid();
    
    boolean isNullQw_productid();
    boolean isNullQw_customerid();
    boolean isNullQw_employeeid();
    boolean isNullQw_agentid();
    boolean isNullQw_ownerid();
    boolean isNullQw_workgroupid();
    boolean isNullQw_dateowned();
    boolean isNullQw_status();
    boolean isNullQw_dateassigned();
    boolean isNullQw_datereported();
    boolean isNullQw_reasoncode();
    boolean isNullQw_resbuildversionid();
    boolean isNullQw_otherreason();
    
    boolean isChangedQw_status();
    boolean isChangedQw_priority();
    boolean isChangedQw_workgroupid();
    boolean isChangedQw_intcomments();
    boolean isChangedQw_productid();
    boolean isChangedQw_ownerid();
    boolean isChangedQw_impact();
    boolean isChangedQw_type();
    boolean isChangedQw_agentid();

    void setQw_ticketid(Long l);
    void setQw_status(Integer i);
    void setQw_priority(Integer i);
    void setQw_type(Integer i);
    void setQw_source(Integer i);
    void setQw_impact(Integer i);
    void setQw_customerid(Long l);
    void setQw_employeeid(Long l);
    void setQw_productid(Long l);
    void setQw_solution(Long l);
    void setQw_agentid(Long l);
    void setQw_workgroupid(Long l);
    void setQw_ownerid(Long l);
    void setQw_datemodified(Date d);
    void setQw_problem(String s);
    void _setQw_descriptiontext(char[] s);
    void _setQw_responsetext(char[] s);
    void setQw_dateassigned(Date d);
    void setQw_eta(Date d);
    void setQw_dateresolved(Date d);
    void setQw_datedelivered(Date d);
    void setQw_dateowned(Date d);
    void setQw_dateclosed(Date d);
    void setQw_modifiedbyid(Long l);
    void setQw_phonetime(Long l);
    void setQw_researchtime(Long l);
    void setQw_datereported(Date d);
    void setQw_lastreopened(Date d);
    void setQw_reopencnt(Integer i);
    void setQw_laststatuschanged(Date d);
    void setQw_reasoncode(Integer i);
    void setQw_otherreason(String s);
    void setQw_resbuildversionid(Long i);
    
}
