/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.gen;

import com.queplix.core.modules.eql.EQLRes;
import com.queplix.core.modules.eql.ejb.EQLManagerLocal;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.integrator.security.LogonSession;
import java.util.List;

/**
 * Description.
 * @author rustem.nizamiev
 * @since 18  2007 ., 15:41
 */
public class TicketObjectHandler extends JEObjectHandler {
    
    public static final String ENTITY = "ticket.ticket";

    // ======================================================= Inherited methods

    /* (non-Javadoc)
     * @see JEObjectHandler.getEntityName()
     */
    public String getEntityName() {
        return ENTITY;
    }

    /* (non-Javadoc)
     * @see JEObjectHandler.getObjectClass()
     */
    public Class getObjectClass() {
        return TicketObject.class;
    }

    // ============================================================= EQL methods

    /**
     * Gets the ticket by its ID (primary key).
     *
     * @param manager JEOManager EJB local interface
     * @param ls LogonSession object with security data
     * @param id ticket ID to search by
     * @return ticket JEO handler, or <code>null</code> if none found
     * @throws EQLException
     */
    public static JEObjectHandler selectByID( JEOManagerLocal manager, LogonSession ls, long id )
        throws EQLException {

        String eql = "select ticket.ticket.* where ticket.ticket.qw_ticketid = " + id;

        List hndList = manager.select( ls, TicketObjectHandler.class, eql );
        return( hndList != null ) ? ( JEObjectHandler ) hndList.get( 0 ) : null;
    }

    public static boolean checkByID(EQLManagerLocal eqlManager, LogonSession ls, long id )
        throws EQLException {
        String eql = "select ticket.qw_ticketid where ticket.qw_ticketid = " + id;
        EQLRes eqlRes = eqlManager.select( ls, eql );
        if(eqlManager.selectCount( ls, eqlRes ) > 0) return true; 
        else return false;
    }
    
}
