/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.inbox;

import com.queplix.core.modules.inbox.InboxHelper;

/**
 * Custom Inbox Helper.
 * @author Konstantin Mironov
 * @since 8 Dec 2006
 */
public class CustomInboxHelper extends InboxHelper {
    /**
     * Pattern variable for a Case ID in header and body (i.e. 'Case : 123').
     */
    public static final String TICKET_ID_PATTERN = "\\s*Ticket : ([0-9]+)";
    public static final String TICKET_ID_CAPTION = "Ticket : ";
    public static final String INTERACTION_ID_CAPTION = "Interaction : ";

    // the tipies of Customer
    public static final int CUSTOMER_TYPE = 1;
    public static final int CUSTOMER_INTERNAL_TYPE = 2;


} // class CustomInboxHelper
