/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.notification;

import java.rmi.*;

import javax.ejb.*;
import javax.naming.*;
import javax.rmi.*;

import com.queplix.core.error.*;
import com.queplix.core.modules.services.*;
import com.queplix.qwoss.utils.CustomJNDINames;

/**
 * Escalation sender.
 *
 * @author [ALB] Baranov Andrey
 * @version $Revision: 1.4 $ $Date: 2005/08/17 09:27:16 $
 */
public class EscalationAction
    extends XAAction {

    // ================================================================== Fields

    // EJB home interfaces
    private TicketEscalationManagerHome ticketEsclManagetHome;

    // ========================================================== Initialization

    /** Creates a new escalation sender. */
    public EscalationAction() {
        try {
            InitialContext context = new InitialContext();

            Object o = context.lookup( CustomJNDINames.TicketEscalationManagerRemote );
            ticketEsclManagetHome = ( TicketEscalationManagerHome )
                PortableRemoteObject.narrow( o, TicketEscalationManagerHome.class );

        } catch( Exception ex ) {
            throw new GenericSystemException( ex );
        }
    }

    // ========================================================== Action handler

    /* (non-Javadoc)
     * @see Action#perform
     */
    public java.io.Serializable perform() {

        INFO( "Escalations sender started..." );

        // Go!
        try {
            TicketEscalationManager caseEsclManager = ticketEsclManagetHome.create();
            int firedCaseEvents = caseEsclManager.fireEvents();

            DEBUG( "Fired " + firedCaseEvents + " case events..." );

        } catch( CreateException ex ) {
            ERROR( ex );
            throw new GenericSystemException( "Create exception: " + ex.getMessage(), ex );

        } catch( RemoteException ex ) {
            ERROR( ex );
            throw new GenericSystemException( "Remote exception: " + ex.getMessage(), ex );

        } catch( GenericSystemException ex ) {
            ERROR( ex );
            throw ex;

        } catch( Throwable t ) {
            ERROR( t );
            throw new GenericSystemException( "Unknown exception: " + t.getMessage(), t );
        }

        // Ok.
        return null;
    }

}
