/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.update;

import com.queplix.core.modules.eql.EQLResCell;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.eql.update.EntityUpdate;

/**
 * Customer update business logic.
 *
 * @author [LIV] Ladnev Ilya
 * @version $Revision: 1.1.1.1 $ $Date: 2005/09/12 15:30:51 $
 */
public class CustomerUpdate
    extends EntityUpdate {

    /* (non-Javadoc)
     * @see EntityUpdate#beforeUpdate()
     */
    public int beforeUpdate() throws EQLException {

        long time = System.currentTimeMillis();
        INFO( "Before update script started..." );

        EQLResCell firstNameCell = getCell( "qw_firstname" );
        EQLResCell lastNameCell = getCell( "qw_lastname" );
        EQLResCell fullNameCell = getCell( "qw_fullname" );
        String firstName = firstNameCell.getString();
        String lastName = lastNameCell.getString();

        String fullName = lastName + ", " + firstName;
        fullNameCell.setString(fullName);

        // Ok.
        INFO( "Completed, time (ms) = " + ( System.currentTimeMillis() - time ) );
        return CONTINUE;
    }
}
