/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.rpc.RPC;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.frames.mainframe.FormOperations;
import com.queplix.core.client.frames.mainframe.FormState;
import com.queplix.qwoss.client.app.rpc.CustomRPC;

/**
 * Description:
 *
 * @author sergei.savchuk
 */

class AttachmentTicketHandler extends AttachmentHandler {

    /*
     * Tiket form id
     * It should initialized in HandlerFactory or it's siblings
     */
    private String ticketFormId;
    
    public void handleCustomButtonEvent(String buttonId) {
        FamgMeta.Index formIndex = getFormIndex();
        if (buttonId.equalsIgnoreCase(LINK_TO_TICKET)) {
            switch (getOperationContext().getFormOperations().getFormState(formIndex)) {
                case FormState.SELECTED_STATE:
                    linkAttachmentToTicket(formIndex);
                    break;
                default:
                    DialogHelper.showModalMessageDialog("This button is available only in SELECTED state.");
            }
        }
        super.handleCustomButtonEvent(
                buttonId);
    }

    protected void linkAttachmentToTicket(FamgMeta.Index form) {
        FormOperations context = getOperationContext().getFormOperations();
        Long atachmentId = context.getSelectedRecordId(form);
        FamgMeta.Index ticketIndex = (FamgMeta.Index) getOperationContext().getMetaData().getIndexByID(ticketFormId);
        Long ticketId = context.getSelectedRecordId(ticketIndex);
        if (ticketId == null) {
            DialogHelper.showModalMessageDialog("The selected ticket record is required to link attachment to ticket.");
            return;
        }
        if (DialogHelper.showModalQuestionDialog("The link between attachment # " + atachmentId +
                " and ticket # " + ticketId + " is going to be created.") == DialogHelper.YES) {
            RPC.QAsyncCallback callback = new CreateLinkAsyncCallback();
            CustomRPC.getCustomRPC().createAttachmentTicketLink(atachmentId, ticketId, callback);
        }
    }

    public void setTicketFormId(String ticketFormId) {
        this.ticketFormId = ticketFormId;
    }
       
}
