/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.frames.mainframe.IMainFrame;
import com.queplix.core.client.frames.mainframe.OperationContext;
import com.queplix.core.client.frames.mainframe.StrategiesFactory;
import com.queplix.core.client.frames.mainframe.impl.DefaultMainFrameBuilder;

/**
 * Builds main frame environment for the qwoss application.
 *
 * Here we simply provides our strategies factory
 *
 * @author Sergey Kozmin
 * @since 13.04.2007
 */
public class MainFrameBuilderQWOss extends DefaultMainFrameBuilder {
    protected StrategiesFactory createStrategiesFactory(OperationContext ctx) {
        return new StrategiesFactoryQWOss(ctx);
    }
}