/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.client.frames.mainframe;

import java.util.ArrayList;
import java.util.Collection;

import com.queplix.core.client.app.vo.EntityData;
import com.queplix.core.client.app.vo.GridSearchProperties;
import com.queplix.core.client.frames.mainframe.DefaultOperationStrategy;

/**
 * Description:
 *
 * @author sergei.savchuk
 */

class TicketEventHandler extends DefaultOperationStrategy {

    private ArrayList externalEntityFilters = new ArrayList();
    void setExternalEntityFilters(ArrayList entityFilters){
        externalEntityFilters = entityFilters;
    }
    void addExternalFilter(EntityData entityFilter){
        if(externalEntityFilters != null)
            externalEntityFilters.add(entityFilter);
    }
    void removeAllExternalFilters(){
        externalEntityFilters.clear();
    }

    public void searchRecords(
            Collection entitiesFilters,
            GridSearchProperties props,
            boolean isLocalSearch) {
        if(externalEntityFilters != null && externalEntityFilters.size()>0 ){
            if(entitiesFilters != null)
                entitiesFilters.addAll(externalEntityFilters);
            else
                entitiesFilters = externalEntityFilters;
            externalEntityFilters = null;
        }
        super.searchRecords(entitiesFilters, props, isLocalSearch);
    }
    
}
