/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.qwoss.client.frames.mainframe;

import com.queplix.core.client.app.rpc.RPC;
import com.queplix.core.client.app.vo.EntityData;
import com.queplix.core.client.app.vo.EntityReferenceData;
import com.queplix.core.client.app.vo.EntityReferenceDataRequest;
import com.queplix.core.client.app.vo.FamgMeta;
import com.queplix.core.client.app.vo.FieldData;
import com.queplix.core.client.app.vo.FieldDataRequest;
import com.queplix.core.client.app.vo.FieldMeta;
import com.queplix.core.client.app.vo.GridSearchProperties;
import com.queplix.core.client.app.vo.ListboxDataRequest;
import com.queplix.core.client.app.vo.ListboxFieldData;
import com.queplix.core.client.app.vo.MetaData;
import com.queplix.core.client.app.vo.MultiselectFieldData;
import com.queplix.core.client.app.vo.RowData;
import com.queplix.core.client.app.vo.SubsetData;
import com.queplix.core.client.app.vo.TextareaFieldData;
import com.queplix.core.client.app.vo.TextboxFieldData;
import com.queplix.core.client.common.CollectionsHelper;
import com.queplix.core.client.common.StringUtil;
import com.queplix.core.client.common.ui.DialogHelper;
import com.queplix.core.client.frames.email.EmailComposeHelper;
import com.queplix.core.client.frames.mainframe.DefaultOperationStrategy;
import com.queplix.core.client.frames.mainframe.FormOperations;
import com.queplix.core.client.frames.mainframe.FormState;
import com.queplix.core.client.frames.mainframe.OperationContext;
import com.queplix.core.client.frames.mainframe.OperationTypes;
import com.queplix.qwoss.client.app.rpc.CustomRPC;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

/**
 * Description:
 * @author rustem.nizamiev, sergei.savchuk
 */
public class TicketHandler extends DefaultOperationStrategy {

    private static final String TICKET_ID_CAPTION = "Ticket : ";

    private static final long BASE_ENTITYROWID = -1;
    private static final int SELECTED_INDEX = 0;
    private static final int STATUS_OWNED = 2;
    private static final String MY_QUEUES = "myQueues";
    private static final String MY_TICKETS = "myTickets";
    private static final String OPEN_TICKETS = "openTickets";
    private static final String ACCEPT_TICKET = "acceptTicket";

    private static final String CHANGE_OWNER_QUESTION = "Would you like to change the owner?";
    
    private static final String TICKET_ID_FIELD_NAME = "qw_ticketid";
    private static final String SUBJECT_FIELD_NAME = "qw_problem";
    private static final String DESCRIPTION_FIELD_NAME = "qw_description";
    private static final String DESCRIPTION_TEXT_FIELD_NAME = "qw_descriptiontext";
    private static final String RESPONSE_FIELD_NAME = "qw_response";
    private static final String RESPONSE_TEXT_FIELD_NAME = "qw_responsetext";
    
    private static final String OWNER = "qw_ownerid";
    private static final String AGENT = "qw_agentid";
    private static final String STATUS = "qw_status";

    public static final String COMPONENT_ID_FIELD_NAME = "qw_componentid"; // 1st constrained control
    public static final String REP_BVERSION_ID_FIELD_NAME = "qw_repbuildversionid"; // 2nd constrained control
    public static final String RES_BVERSION_ID_FIELD_NAME = "qw_resbuildversionid"; // 3rd constrained control
    public static final String REP_ENV_ID_FIELD_NAME = "qw_repenvironmentid"; // 4th constrained control
    public static final String TEST_ENV_ID_FIELD_NAME = "qw_testenvironmentid"; // 5th constrained control

    public static final String PRODUCT_ID_FIELD_NAME = "qw_productid"; // constraint-source control
    public static final String CUSTOMER_ID_FIELD_NAME = "qw_customerid";
    public static final String EMPLOYEE_ID_FIELD_NAME = "qw_employeeid";
    public static final String CUSTOMER_TICKET_ENTITY_NAME = "customer.foreign";
    public static final String CUSTOMER_TICKET_ENTITY_PKEYFIELD_NAME = "qw_customerid";

    public static final String COMPONENT_FILTER_FIELD_NAME
            = "qw_productid"; //field name in entity, where this entityReference is referencing.
    public static final String BVERSION_FILTER_FIELD_NAME
            = "qw_productid"; //field name in entity, where this entityReference is referencing.
    public static final String ENV_FILTER_FIELD_NAME = "qw_productid"; //field name in entity, where this entityReference is referencing.
    //public static final String ENVCUST_FILTER_FIELD_NAME = "qw_orgid"; //field name in entity, where this entityReference is referencing.

    public static final String SUB_CATEGORY_FIELD_NAME = "qw_subcategory"; //filtering field
    public static final String CATEGORY_FIELD_NAME = "qw_category"; //filter sub-category by category id
    public static final String CATEGORY_FIELD_IN_SUBCATEGORY_ENTITY = "qw_categoryid"; //filter field name in sub-category entity

    private static final String CUR_INTERACTION_ID_FIELD = "qw_cur_interaction";
    private static final String SOLUTION_CUR_TICKET_ID_FIELD = "qw_cur_ticket";
    private static final String SOLUTION_PRODUCT_FIELD = "qw_productid";
    private static final String SOLUTION_COMPONENT_FIELD = "qw_componentid";
    private static final String SOLUTION_SUMMARY_FIELD = "qw_summary";
    private static final String SOLUTION_PROBLEM_FIELD = "qw_problem";
    private static final String SOLUTION_PROBLEM_TEXT_FIELD = "qw_problemtext";
    private static final String SOLUTION_SOL_FIELD = "qw_solution";
    private static final String SOLUTION_SOL_TEXT_FIELD = "qw_solutiontext";
    
    private static final String LINKET_TICKETS_FIELD = "linked_tickets";
    private static final String INTERACTION_ID_FIELD = "qw_interactionid";

    private static final String LINK_TO_INTERACTION_BUTTON = "LINK_TO_INTERACTION_BUTTON";
    private static final String NEW_SOLUTION_BUTTON = "NEW_SOLUTION_BUTTON";
    private static final String SEND_EMAIL_BUTTON = "SEND_EMAIL_BUTTON";
    
    private static final String TICKET_ENTITY = "ticket.ticket";
    private static final String INTER_TICKET_ENTITY = "inter_ticket.linkset";
    private static final String INTER_TICKET_FILTER_FIELD = "qw_ticketid";
    
    private static final String TICKETEVENT_ENTITY = "ticketevent.ticket";
    private static final String TICKETEVENT_FILTER_FIELD = "qw_ticketid";

    private static final String ATTACH_FILE = "ATTACH_FILE";
    private static final String ATTACHMENT_OBJECTS_ENTITY = "attachment_objects.ticket";
    private static final String OBJECT_ID = "object_id";
    
    private ListboxFieldData oldCategoryData = null;
    private FieldData[] initialFieldsData = null;
    private String curOriginInteractionId = "0";

    private HashMap replyInitVals;
    private ReplyComposeDialog replyDialog;

    /*
     * Interaction and AttachmentTicket form ids
     * It should initialized in HandlerFactory or it's siblings
     */
    private String interFormId, attachTicketFormId, solutionFormId, eventFormId;

    // Ties with other handlers
    private InteractionHandler interHandler;
    private AttachmentTicketHandler attachHandler;
    private SolutionHandler solutionHandler;
    private TicketEventHandler eventHandler;

    private String eventId;
    private ArrayList externalEntityFilters = new ArrayList();
    //private String externalEQLFilter = "";
    
    //void setExternalEQLFilter(String eqlFilter){
    //    externalEQLFilter = eqlFilter;
    //}
    void setExternalEntityFilters(ArrayList entityFilters){
        externalEntityFilters = entityFilters;
    }
    void addExternalFilter(EntityData entityFilter){
        if(externalEntityFilters == null)
            externalEntityFilters = new ArrayList();    
        externalEntityFilters.add(entityFilter);
    }
    void removeAllExternalFilters(){
        externalEntityFilters.clear();
    }
    
    private static final Set allowedStatus = new HashSet();
    static {
        allowedStatus.add(new Long(TicketHelper.NEW_STATUS));
        allowedStatus.add(new Long(TicketHelper.ASSIGNED_STATUS));
        allowedStatus.add(new Long(TicketHelper.OWNED_STATUS));
    }

    public void searchRecords(Collection entitiesFilters,
                              GridSearchProperties props,
                              boolean isLocalSearch) {
        //DialogHelper.showModalMessageDialog("HERE ARE:");
        if(externalEntityFilters != null && externalEntityFilters.size() > 0) {
            if(entitiesFilters != null) {
                entitiesFilters.addAll(externalEntityFilters);
            } else {
                entitiesFilters = externalEntityFilters;
            }
            externalEntityFilters = null;
        }
            
        super.searchRecords(entitiesFilters, props, isLocalSearch);
        eventId = null;
    }
    
    public void handleCustomMenuEvent(String eventId) {
        if(eventId == null) return;
        FamgMeta.Index formIndex = getFormIndex();
        //Set event for future use.
        this.eventId = eventId;
        if (eventId.equals(MY_QUEUES) || eventId.equals(MY_TICKETS) || eventId.equals(OPEN_TICKETS)) {
            FormOperations formContext = getOperationContext().getFormOperations();
            if(eventId.equals(MY_QUEUES)){
                EntityReferenceData erd = new EntityReferenceData(OWNER);
                erd.setSelectedRowID(new Long(getUserId()));
                addExternalFilter(
                        new EntityData(TICKET_ENTITY, new Long(-1), 
                        new FieldData[] { erd } ));
            } else
            if(eventId.equals(MY_TICKETS)){
                EntityReferenceData erd = new EntityReferenceData(AGENT);
                erd.setSelectedRowID(new Long(getUserId()));
                addExternalFilter(
                        new EntityData(TICKET_ENTITY, new Long(-1), 
                        new FieldData[] { erd } ));
            } else
            if(eventId.equals(OPEN_TICKETS)){
                ListboxFieldData lbfd = new ListboxFieldData(STATUS,
                   new SubsetData(CollectionsHelper.createIncrementalArray(TicketHelper.CLOSED_STATUS, 0)));
                addExternalFilter(
                        new EntityData(TICKET_ENTITY, new Long(-1), 
                        new FieldData[] { lbfd } ));
            }    
            formContext.clearForm(formIndex, true);
            getOperationContext().performOperation(OperationTypes.SEARCH_RECORDS, formIndex);
        }
        if (eventId.equals(ACCEPT_TICKET)) {
            // check all custom dependances(conditions)
            if(checkDependences(formIndex)) {
                getOperationContext().performOperation(OperationTypes.LOCK_AND_EDIT_RECORD, formIndex);
            }
        }
    }

    private boolean checkDependences(FamgMeta.Index formIndex) {
        FormOperations formContext = getOperationContext().getFormOperations();
        int state = formContext.getFormState(formIndex);
        if(state != FormState.SELECTED_STATE) {
            return false;
        }

        int type = getOperationContext().getMetaData().getFamgMeta(formIndex).getForm().getEntityMeta().getField(STATUS).getDataType();
        if(type == FieldMeta.LISTBOX) {
            //get current status
            FieldData statusField = formContext.getFieldData(formIndex, STATUS);
            long curStatus = ((ListboxFieldData) statusField).getItemsSelected()
                    .getSelectedIDs()[SELECTED_INDEX];
            if(!allowedStatus.contains(new Long(curStatus))) {
                return false;
            }
        }
        FieldData ownerField = formContext.getFieldData(formIndex, OWNER);
        if(ownerField instanceof EntityReferenceData) {
            Long selRowId = ((EntityReferenceData) ownerField) .getSelectedRowID();
            if(selRowId != null && getUserId() != selRowId.longValue()) {
                if(DialogHelper.showModalQuestionDialog(CHANGE_OWNER_QUESTION)
                        == DialogHelper.NO) {
                    return false;
                }
            }
        }

        return true;
    }

    private long getUserId() {
        return getOperationContext().getMetaData().getUserProfile().getUserID();
    }

    private String getUserFullname() {
        return getOperationContext().getMetaData().getUserProfile().getFullName();
    }

    public void handleControlDataRequest(FieldDataRequest request) {
        FamgMeta.Index formIndex = getFormIndex();
        FormOperations context = getOperationContext().getFormOperations();
        String elementID = request.getElementID();
        if(COMPONENT_ID_FIELD_NAME.equalsIgnoreCase(elementID)) {
            EntityReferenceDataRequest theRequest = (EntityReferenceDataRequest) request;
            FieldData productData = context.getFieldData(formIndex,
                    PRODUCT_ID_FIELD_NAME);
            FieldData cloned = productData.cloneData();
            cloned.setFieldID(COMPONENT_FILTER_FIELD_NAME);
            theRequest.setAdditionalFilterForRequestingEntity(cloned);
        } else if(REP_BVERSION_ID_FIELD_NAME.equalsIgnoreCase(elementID)) {
            EntityReferenceDataRequest theRequest = (EntityReferenceDataRequest) request;
            FieldData productData = context.getFieldData(formIndex,
                    PRODUCT_ID_FIELD_NAME);
            FieldData cloned = productData.cloneData();
            cloned.setFieldID(BVERSION_FILTER_FIELD_NAME);
            theRequest.setAdditionalFilterForRequestingEntity(cloned);
        } else if(RES_BVERSION_ID_FIELD_NAME.equalsIgnoreCase(elementID)) {
            EntityReferenceDataRequest theRequest = (EntityReferenceDataRequest) request;
            FieldData productData = context.getFieldData(formIndex,
                    PRODUCT_ID_FIELD_NAME);
            FieldData cloned = productData.cloneData();
            cloned.setFieldID(BVERSION_FILTER_FIELD_NAME);
            theRequest.setAdditionalFilterForRequestingEntity(cloned);
        } else if(REP_ENV_ID_FIELD_NAME.equalsIgnoreCase(elementID)) {
            EntityReferenceDataRequest theRequest = (EntityReferenceDataRequest) request;
            theRequest.clearAdditionalFilter();//clear previous filters, because it might be singleton-event-object.

            FieldData productData = context.getFieldData(formIndex,
                    PRODUCT_ID_FIELD_NAME);
            if(!productData.isEmpty()) {
                FieldData cloned = productData.cloneData();
                cloned.setFieldID(ENV_FILTER_FIELD_NAME);
                theRequest.addAdditionalFilterForRequestingEntity(cloned);
            }
            EntityReferenceData customerIdData = (EntityReferenceData) context.getFieldData(
                    formIndex, CUSTOMER_ID_FIELD_NAME);
            if(customerIdData.getSelectedRowID() != null) {
                FieldData data = new TextboxFieldData(CUSTOMER_TICKET_ENTITY_PKEYFIELD_NAME, customerIdData.getSelectedRowID().toString());
                theRequest.addAdditionalFilter(data, CUSTOMER_TICKET_ENTITY_NAME);
            }
        } else if(TEST_ENV_ID_FIELD_NAME.equalsIgnoreCase(elementID)) {
            EntityReferenceDataRequest theRequest = (EntityReferenceDataRequest) request;
            FieldData productData = context.getFieldData(formIndex,
                    PRODUCT_ID_FIELD_NAME);
            //FieldData customerData = form.getModel().getElementData(CUSTOMER_ID_FIELD_NAME);
            FieldData cloned = productData.cloneData();
            //FieldData cloned_cust = (FieldData) customerData.cloneData();
            cloned.setFieldID(ENV_FILTER_FIELD_NAME);
            //cloned_cust.setFieldID(ENVCUST_FILTER_FIELD_NAME);
            theRequest.setAdditionalFilterForRequestingEntity(cloned);
            //theRequest.setAdditionalFilter(cloned_cust);
        } else if(SUB_CATEGORY_FIELD_NAME.equalsIgnoreCase(elementID)) {
            ListboxDataRequest listBoxReq = (ListboxDataRequest) request;
            ListboxFieldData categoryData = (ListboxFieldData) context.getFieldData(
                    formIndex, CATEGORY_FIELD_NAME);
            boolean isChange = compareFieldData(oldCategoryData, categoryData);
            if(!isChange) {
                return;
            }
            //if(!categoryData.isEmpty()) {
            FieldData cloned = categoryData.cloneData();
            cloned.setFieldID(CATEGORY_FIELD_IN_SUBCATEGORY_ENTITY);
            listBoxReq.setAdditionalFilter(cloned);
            //}
            oldCategoryData = (ListboxFieldData) categoryData.cloneData();
        }
        super.handleControlDataRequest(request);
    }

    public void setInitialFieldsData(FieldData[] fieldsData){
        initialFieldsData = fieldsData;
    }

    protected void lockAndEditResponse(boolean success,
                                       EntityData[] entitiesList,
                                       EntityData[] externalFieldsList,
                                       Collection gridData) {

        super.lockAndEditResponse(success, entitiesList, externalFieldsList,
                gridData);
        
        if(!success || eventId == null) return;

        FamgMeta.Index formIndex = getFormIndex();
        FormOperations context = getOperationContext().getFormOperations();
        EntityReferenceData ownerField = new EntityReferenceData(OWNER);
        ownerField.setSelectedRowID(new Long(getUserId()));
        ownerField.setSelectedFilter(getUserFullname());
        context.setFieldData(formIndex, ownerField);
        
        ListboxFieldData statusField = new ListboxFieldData(STATUS, new SubsetData(new long[]{STATUS_OWNED}));
        context.setFieldData(formIndex, statusField);
        
        //EntityReferenceData ownerField = (EntityReferenceData) context.getFieldData(OWNER, index);
        //ListboxFieldData statusField = (ListboxFieldData) context.getFieldData(STATUS, index);
        //statusField.setItemsSelected(new SubsetData(new long[]{STATUS_OWNED}));
        //ownerField.setSelectedRowID(new Long(getUserId()));
        //ownerField.setSelectedFilter(getUserFullname());
        eventId = null;

    }

    protected void createRecordProtorypeResponse(boolean success,
                                                 FieldData[] fields,
                                                 Long rowId) {
        super.createRecordProtorypeResponse(success, fields, rowId);

        if(!success) {
            return;
        }

        FamgMeta.Index formIndex = getFormIndex();
        if(initialFieldsData != null && initialFieldsData.length > 0) {
            FormOperations formContext = getOperationContext().getFormOperations();
            for(int i = 0; i < initialFieldsData.length; i++) {
                if(initialFieldsData[i] != null) {
                    formContext.setFieldData(formIndex, initialFieldsData[i]);
                }
            }
            String originInterId = ((TextboxFieldData) formContext.getFieldData(
                    formIndex, CUR_INTERACTION_ID_FIELD)).getText();
            curOriginInteractionId = (originInterId != null) ? originInterId : "0";
            initialFieldsData = null;
        } else {
            curOriginInteractionId = "0";
        }
    }

    protected void insertRecordResponse(boolean success,
                                        EntityData[] entitiesList,
                                        EntityData[] externalFieldsList,
                                        Collection gridData,
                                        RowData updatedRow) {
        super.insertRecordResponse(success, entitiesList, externalFieldsList, gridData, updatedRow);

        FormOperations formContext = getOperationContext().getFormOperations();

        if(!success) return;
        if(!curOriginInteractionId.equals("0")){
            FamgMeta.Index formIndex = getFormIndex();
            long ticketId = formContext.getSelectedRecordId(formIndex).longValue();
            String interId = ((TextboxFieldData) formContext.getFieldData(
                    formIndex, INTERACTION_ID_FIELD)).getText();
            if( FormState.NEW_STATE == getOperationContext().getFormOperations().getFormState(formIndex) &&
                    curOriginInteractionId.equals(interId) ){
                linkToTicketDataset(formIndex, ticketId);
            }
            curOriginInteractionId = "0";
        }
    }

    private void linkToTicketDataset(FamgMeta.Index interationIndex, long ticketId){
        FormOperations formContext = getOperationContext().getFormOperations();
        MultiselectFieldData linksData = (MultiselectFieldData) formContext.getFieldData(
                interationIndex, LINKET_TICKETS_FIELD);
        long[] selLinks = linksData.getItemsSelected().getSelectedIDs();
        long[] newSelLinks = {ticketId};
        if(selLinks != null){
            newSelLinks = new long[selLinks.length+1];
            for(int i=0;i<selLinks.length;i++)
                if(selLinks[i] != ticketId)
                    newSelLinks[i] = selLinks[i];
                else{
                    DialogHelper.showModalMessageDialog("The link to Ticket # "+ticketId+" already exists.");
                    return;
                }
            newSelLinks[newSelLinks.length-1]= ticketId;
        }
        MultiselectFieldData newLinksData = new MultiselectFieldData(LINKET_TICKETS_FIELD, new SubsetData(newSelLinks));
        formContext.setFieldData(interationIndex, newLinksData);
    }

    public void handleCustomButtonEvent(String buttonId) {
        FamgMeta.Index formIndex = getFormIndex();
        FormOperations formContext = getOperationContext().getFormOperations();
        int state = formContext.getFormState(formIndex);
        if( buttonId.equalsIgnoreCase(LINK_TO_INTERACTION_BUTTON) ){
            switch(state){
                case FormState.SELECTED_STATE:
                case FormState.EDIT_STATE:
                    //DialogHelper.showModalMessageDialog("Under construction...");
                    linkTicketToInteraction(formIndex);
                    break;
                default:
                    DialogHelper.showModalMessageDialog("This button is available only in EDIT or SELECTED state.");
            }
        } else if(buttonId.equalsIgnoreCase(NEW_SOLUTION_BUTTON)) {
            switch(state) {
                case FormState.SELECTED_STATE:
                    createSolutionFromNewState(formIndex);
                    break;
                default:
                    DialogHelper.showModalMessageDialog(
                            "This button is available only in SELECTED state.");
                    break;
            }
        } else if(buttonId.equals(ATTACH_FILE)) {
            switch (state) {
                case FormState.SELECTED_STATE:
                    createNewAttachment(formIndex);
                    break;
                default:
                    DialogHelper.showModalMessageDialog("This button is available only in SELECTED state.");
            }
        } else if(buttonId.equals(SEND_EMAIL_BUTTON)) {
            switch (state) {
                case FormState.SELECTED_STATE:
                    sendReplyEmail(formIndex);
                    break;
                default:
                    DialogHelper.showModalMessageDialog("This button is available only in SELECTED state.");
            }
        }
    }

    private void sendReplyEmail(FamgMeta.Index formIndex) {
        replyInitVals = new HashMap();

        FormOperations context = getOperationContext().getFormOperations();
        FieldData ticketIdFld = context.getFieldData(formIndex,
                TICKET_ID_FIELD_NAME);
        FieldData custIdFld =   context.getFieldData(formIndex,
                CUSTOMER_ID_FIELD_NAME);
        FieldData empIdFld =    context.getFieldData(formIndex,
                EMPLOYEE_ID_FIELD_NAME);
        FieldData subjectFld =  context.getFieldData(formIndex,
                SUBJECT_FIELD_NAME);
        FieldData messageFld =  context.getFieldData(formIndex,
                DESCRIPTION_FIELD_NAME);
        
        int objectType = OperationsHelper.TICKET_OBJECT_TYPE;
        long objectId = Long.parseLong( ((TextboxFieldData)ticketIdFld).getText() );
        
        String oldSubject = "";
        if(!subjectFld.isEmpty()){
            oldSubject = ((TextboxFieldData)subjectFld).getText();
        }
        
        String newSubject = ("QueWeb "+ TICKET_ID_CAPTION + objectId+" : "+oldSubject).substring(0,255);
        replyInitVals.put(EmailComposeHelper.SUBJECT_MAP_FIELD, newSubject);
        //DialogHelper.showModalMessageDialog("newSubject "+newSubject);
        Long initCustomerId = null; boolean isCustomer = false;
        if(!custIdFld.isEmpty()){
            initCustomerId = ((EntityReferenceData)custIdFld).getSelectedRowID();
            isCustomer = true;
        } else if(!empIdFld.isEmpty()){
            initCustomerId = ((EntityReferenceData)empIdFld).getSelectedRowID();
            isCustomer = false;
        }
        //DialogHelper.showModalMessageDialog("initCustomerId "+initCustomerId);
        //DialogHelper.showModalMessageDialog("oldSubject "+oldSubject);
        String oldMessage = "";
        if(!messageFld.isEmpty()){
            oldMessage = ((TextareaFieldData)messageFld).getText();
        }
        //DialogHelper.showModalMessageDialog("oldMessage "+oldMessage);
        if(initCustomerId != null ){
            FromAndToEmailAsyncCallback callback = new FromAndToEmailAsyncCallback(objectType, objectId, oldSubject, oldMessage);
            CustomRPC.getCustomRPC().getFromAndToEmail(objectType, objectId, isCustomer, initCustomerId, callback);
        } else {
            DialogHelper.showModalMessageDialog("Can't get customer or internal custore to determine recipient address.");
        }
    }
    
    private void linkTicketToInteraction(FamgMeta.Index formIndex){
        FormOperations context = getOperationContext().getFormOperations();
        Long ticketId = context.getSelectedRecordId(formIndex);
        FamgMeta.Index interactionIndex = (FamgMeta.Index) getOperationContext().getMetaData().getIndexByID(interFormId);
        Long interId = context.getSelectedRecordId(interactionIndex);
        if(interId == null){
            DialogHelper.showModalMessageDialog("Interaction Record must be selected on the Interaction Tab.\nPlease navigate to it, select desired Interaction and click Link again.");
        } else {
            int answer = DialogHelper.showModalQuestionDialog(
                    "The link between ticket # " + ticketId
                            + " and interaction # " + interId
                            + " is going to be created.");
            if(DialogHelper.YES == answer) {
                if(FormState.NEW_STATE == context.getFormState(interactionIndex)) {
                    linkToTicketDataset(interactionIndex, ticketId.longValue());
                } else {
                    RPC.QAsyncCallback callback = new CreateLinkAsyncCallback();
                    CustomRPC.getCustomRPC().createTicketInteractionLink(
                            ticketId, interId, callback);
                }
            }
        }
    }

    private void createNewAttachment(FamgMeta.Index formIndex) {
        FormOperations formContext = getOperationContext().getFormOperations();
        FieldData ticketId = formContext.getFieldData(formIndex,
                TICKET_ID_FIELD_NAME);
        FieldData clonedTicketId = ticketId.cloneData();
        FieldData[] initData = new FieldData[6];
        initData[0] = clonedTicketId;

        attachHandler.setInitialFieldsData(initData);
        OperationsHelper.createNewRecord(attachTicketFormId, getOperationContext());
    }

    public void handleLinkEvent(String fromLinkFieldId) {

        FamgMeta.Index formIndex = getFormIndex();
        OperationContext context = getOperationContext();
        FormOperations formContext = context.getFormOperations();
        MetaData metadata = context.getMetaData();
        FamgMeta formMeta = metadata.getFamgMeta(formIndex);
        FieldMeta fieldMeta = formMeta.getForm().getEntityMeta().getField(fromLinkFieldId);
        FamgMeta.Index toFormIndex = fieldMeta.getLinkedForm();
        String linkedForm = metadata.getFormID(toFormIndex);

        int state = formContext.getFormState(formIndex);
        switch (state){
            case FormState.SELECTED_STATE:
                ArrayList linkFilter = new ArrayList();
                if (linkedForm.equalsIgnoreCase(interFormId)){ // the link for ticket form is pressed
                    linkFilter.add(
                            new EntityData(INTER_TICKET_ENTITY, new Long(-1), 
                            new FieldData[] {
                                new TextboxFieldData( INTER_TICKET_FILTER_FIELD, 
                                    formContext.getSelectedRecordId(formIndex).toString()
                                )
                            }));
                    interHandler.setExternalEntityFilters(linkFilter);                  
                } else if (linkedForm.equalsIgnoreCase(attachTicketFormId)) {
                    linkFilter.add(
                            new EntityData(ATTACHMENT_OBJECTS_ENTITY, new Long(-1), 
                            new FieldData[] {
                                new TextboxFieldData( OBJECT_ID, 
                                    formContext.getSelectedRecordId(formIndex).toString()
                                )
                            }));
                    attachHandler.setExternalEntityFilters(linkFilter);                  
                } else if (linkedForm.equalsIgnoreCase(eventFormId)) {
                    EntityReferenceData erd = new EntityReferenceData(TICKETEVENT_FILTER_FIELD);
                    erd.setSelectedRowID(formContext.getSelectedRecordId(formIndex));
                    //formContext.setFieldData(erd, toFormIndex);
                    linkFilter.add(
                            new EntityData(TICKETEVENT_ENTITY, new Long(-1), 
                            new FieldData[] { erd } ));
                    eventHandler.setExternalEntityFilters(linkFilter);                  
                }
                else
                    break;
                //clear form
                context.getGridOperations().activateGrid(toFormIndex);
                context.getFormOperations().activateForm(toFormIndex);
                formContext.clearForm(toFormIndex, true);
                //perform search
                getOperationContext().performOperation(OperationTypes.SEARCH_RECORDS, toFormIndex);
                return;
        }
        //surfe to form
        super.handleLinkEvent(fromLinkFieldId);
    }

    protected void createSolutionFromNewState(FamgMeta.Index formIndex){
        FormOperations context = getOperationContext().getFormOperations();

        FieldData ticketStatus = context.getFieldData(formIndex, STATUS);
        boolean wrongStatus = false;
        if(!ticketStatus.isEmpty()) {
            long selId = ((ListboxFieldData) ticketStatus).getItemsSelected()
                    .getSelectedIDs()[0];
            switch((int) selId) {
                case TicketHelper.RELEASE_CANDIDATE_STATUS:
                case TicketHelper.DELIVERED_STATUS:
                case TicketHelper.CLOSED_STATUS:
                    break;
                default:
                    wrongStatus = true;
            }
        } else {
            wrongStatus = true;
        }
        if(wrongStatus){
            DialogHelper.showModalMessageDialog("This button is available only if ticket status is release candidate, delivered or closed.");
            return;
        }
        
        FieldData ticketId =        context.getFieldData(formIndex,
                TICKET_ID_FIELD_NAME);
        FieldData ticketProduct =   context.getFieldData(formIndex,
                PRODUCT_ID_FIELD_NAME);
        FieldData ticketComponent = context.getFieldData(formIndex,
                COMPONENT_ID_FIELD_NAME);
        FieldData ticketSubject =   context.getFieldData(formIndex,
                SUBJECT_FIELD_NAME);
        FieldData ticketDesc =      context.getFieldData(formIndex,
                DESCRIPTION_FIELD_NAME);
        FieldData ticketDescText =  context.getFieldData(formIndex,
                DESCRIPTION_TEXT_FIELD_NAME);
        FieldData ticketResp =      context.getFieldData(formIndex,
                RESPONSE_FIELD_NAME);
        FieldData ticketRespText =  context.getFieldData(formIndex,
                RESPONSE_TEXT_FIELD_NAME);
        
        FieldData clonedTicketId = ticketId.cloneData();
        clonedTicketId.setFieldID(SOLUTION_CUR_TICKET_ID_FIELD);
        
        FieldData clonedProduct = null;
        FieldData clonedComponent = null;
        FieldData clonedSubject = null;
        FieldData clonedDesc = null;
        FieldData clonedDescText = null;
        FieldData clonedResp = null;
        FieldData clonedRespText = null;
        
        if(!ticketProduct.isEmpty()){ 
            clonedProduct = ticketProduct.cloneData();
            clonedProduct.setFieldID(SOLUTION_PRODUCT_FIELD);
        }
        if(!ticketComponent.isEmpty()){ 
            clonedComponent = ticketComponent.cloneData();
            clonedComponent.setFieldID(SOLUTION_COMPONENT_FIELD);
        }    
        if(!ticketSubject.isEmpty()){ 
            clonedSubject = ticketSubject.cloneData();
            clonedSubject.setFieldID(SOLUTION_SUMMARY_FIELD);
        }    
        if(!ticketDesc.isEmpty()){ 
            clonedDesc = ticketDesc.cloneData();
            clonedDesc.setFieldID(SOLUTION_PROBLEM_FIELD);
        }
        if(!ticketDescText.isEmpty()){ 
            clonedDescText = ticketDescText.cloneData();
            clonedDescText.setFieldID(SOLUTION_PROBLEM_TEXT_FIELD);
        }
        if(!ticketResp.isEmpty()){ 
            clonedResp = ticketResp.cloneData();
            clonedResp.setFieldID(SOLUTION_SOL_FIELD);
        }
        if(!ticketRespText.isEmpty()){ 
            clonedRespText = ticketRespText.cloneData();
            clonedRespText.setFieldID(SOLUTION_SOL_TEXT_FIELD);
        }

        FieldData[] initData = new FieldData[8];
        initData[0] = clonedTicketId;
        initData[1] = clonedProduct;
        initData[2] = clonedComponent;
        initData[3] = clonedSubject;
        initData[4] = clonedDesc;
        initData[5] = clonedDescText;
        initData[6] = clonedResp;
        initData[7] = clonedRespText;
        
        initializeHandler(initData);
    }    

    public static boolean compareFieldData(ListboxFieldData data1, ListboxFieldData data2) {
        if(data1 == null && data2 != null) {
            return true;
        }
        if(data1 != null && data2 == null) {
            return true;
        }
        long[] ids1 = data1.getItemsSelected().getSelectedIDs();
        long[] ids2 = data2.getItemsSelected().getSelectedIDs();
        if(ids1.length != ids2.length) {
            return true;
        } else {
            for(int i = 0; i < ids1.length; i++) {
                if(ids1[i] != ids2[i]) {
                    return true;
                }
            }
        }
        return false;
    }

    protected void initializeHandler(FieldData[] initData){
        solutionHandler.setInitialFieldsData(initData);
        OperationsHelper.createNewRecord(solutionFormId, getOperationContext());
    }

    public void setSolutionHandler(SolutionHandler solutionHandler) {
        this.solutionHandler = solutionHandler;
    }

    public void setAttachHandler(AttachmentTicketHandler attachHandler) {
        this.attachHandler = attachHandler;
    }

    public void setInterHandler(InteractionHandler interHandler) {
        this.interHandler = interHandler;
    }

    public void setInterFormId(String interFormId) {
        this.interFormId = interFormId;
    }

    public void setTicketEventHandler(TicketEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void setTicketEventFormId(String eventFormId) {
        this.eventFormId = eventFormId;
    }
    
    public void setAttachTicketFormId(String attachTicketFormId) {
        this.attachTicketFormId = attachTicketFormId;
    }

    public void setSolutionFormId(String solutionFormId) {
        this.solutionFormId = solutionFormId;
    }

    private class FromAndToEmailAsyncCallback extends RPC.QAsyncCallback {
        int objectType;
        long objectId;
        String oldMessage;
        String oldSubject;
        public FromAndToEmailAsyncCallback(int objType, long objId, String subject, String text) {
            objectType = objType;
            objectId = objId;
            oldSubject = subject;
            oldMessage = text;
        }
        public void onRequestEnded(boolean success, Object result) {
            if(success) {
                boolean isOk = true;
                String fromAdr = "";
                String toAdr = "";
                if(result == null) {
                    isOk = false;
                } else if(!(result instanceof String[])) {
                    isOk = false;
                } else {
                    String[] retEmails = (String[]) result;
                    if(retEmails.length != 2) {
                        isOk = false;
                    } else {
                        fromAdr = retEmails[0];
                        toAdr = retEmails[1];
                        if(StringUtil.isStringEmpty(fromAdr) || StringUtil
                                .isStringEmpty(toAdr))
                            isOk = false;
                    }
                }
                if(!isOk) {
                    DialogHelper.showModalMessageDialog(
                            "Can't get email adresses. Reply can't be sent.");
                    return;
                }

                String newBody = "\n----------------------------------------" +
                        "\nFrom: " + toAdr +
                        "\nSubject: " + oldSubject +
                        "\nDescription:\n" + oldMessage;

                replyInitVals.put(EmailComposeHelper.FROM_MAP_FIELD, fromAdr);
                replyInitVals.put(EmailComposeHelper.TO_MAP_FIELD, toAdr);
                replyInitVals.put(EmailComposeHelper.BODY_MAP_FIELD, newBody);

                if(replyDialog == null) {
                    replyDialog = new ReplyComposeDialog("Send Email Form");
                }
                replyDialog.setInitialDataMap(replyInitVals);
                replyDialog.setObjectType(objectType);
                replyDialog.setObjectId(objectId);
                replyDialog.show(true);
            } else {
                DialogHelper.showModalMessageDialog(
                        "RPC call failed. Reply can't be sent.");
            }
        }
    }

    private class CreateLinkAsyncCallback extends RPC.QAsyncCallback {
        public CreateLinkAsyncCallback() {
        }

        public void onRequestEnded(boolean success, Object result) {
            if(success) {
                Boolean rv = (Boolean) result;
                if(rv != null) {
                    if(rv == Boolean.FALSE) {
                        DialogHelper.showModalMessageDialog(
                                "The link already exists.");
                    } else {
                        DialogHelper.showModalMessageDialog(
                                "The link is created.");
                    }
                }
            } else {
                DialogHelper.showModalMessageDialog("RPC call failed.");
            }
        }
    }
}
