/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.qwoss.server.app.rpc;

import com.queplix.core.client.app.rpc.DisplayableException;
import com.queplix.core.integrator.security.LogonSession;
import com.queplix.core.integrator.security.WebLoginManager;
import com.queplix.core.modules.eql.error.EQLException;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocal;
import com.queplix.core.modules.jeo.ejb.JEOManagerLocalHome;
import com.queplix.core.modules.services.ejb.ScriptManager;
import com.queplix.core.modules.services.ejb.ScriptManagerHome;
import com.queplix.core.utils.JNDINames;
import com.queplix.core.utils.cache.CacheObjectManager;
import com.queplix.core.utils.log.AbstractLogger;
import com.queplix.core.utils.log.Log;

import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;

/*
import com.queplix.core.modules.jeo.JEObjectHandler;
import com.queplix.qwoss.gen.InteractionTicketObject;
import com.queplix.qwoss.gen.InteractionTicketObjectHandler;
*/
/**
 * Application custom RPC methods implementation.
 * @author Ladnev ILya
 * @since 12 Feb 2007
 */

public class QTaskHelper {
    // Logger reference.
    private static final AbstractLogger logger = Log.getLog(QTaskHelper.class);

    public static Boolean stopTask(Long taskID, HttpServletRequest request)
        throws DisplayableException, EQLException {
        LogonSession ls = WebLoginManager.getLogonSession(request);
        
        ScriptManager scriptManager = ( ScriptManager )
            new CacheObjectManager().getRemoteObject( JNDINames.ScriptManagerRemote, ScriptManagerHome.class );
            
        // Set task status to "Interrupted"
        try {
            scriptManager.interruptTask(taskID, false);
        } catch( EQLException ex ) {
             return Boolean.FALSE;            
        } catch( RemoteException ex ) {
             return Boolean.FALSE;            
        }
        return Boolean.TRUE;                   
    }

    public static Boolean startTask(Long taskID, HttpServletRequest request)
            throws DisplayableException, EQLException {
        LogonSession ls = WebLoginManager.getLogonSession(request);

        ScriptManager scriptManager = ( ScriptManager )
            new CacheObjectManager().getRemoteObject( JNDINames.ScriptManagerRemote, ScriptManagerHome.class );
            
        // Set task status to "Ready"
        try {
            scriptManager.readyTask(taskID, false);
        } catch( EQLException ex ) {
             return Boolean.FALSE;            
        } catch( RemoteException ex ) {
             return Boolean.FALSE;            
        }
        return Boolean.TRUE;                   
    }

    
    
}