/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.entity.Chain;
import com.queplix.entity.Chains;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MergeChainsSchema {
    public static final Logger logger = Logger.getLogger("global");

    MergeChainsSchema() {
    }

    public static void mergeChainsSchema(QApplication application) {
        logger.log(Level.INFO, "Start merging qmodules chains metadata.");
        Set<String> modulesNames = application.getDependecyModulesOrder();
        Map<String, QModule> modules = application.getQModules();
        LinkedHashMap<String, Chain> availableChains = new LinkedHashMap<String, Chain>();
        for (String moduleName : modulesNames) {
            Chain[] chains;
            QModule module = modules.get(moduleName);
            for (Chain chain : chains = module.getChains().getChain()) {
                String key = MergeChainsSchema.generateChainKey(chain.getE1(), chain.getE2());
                if (!availableChains.containsKey(key)) {
                    availableChains.put(key, chain);
                    continue;
                }
                logger.log(Level.WARNING, "Module [" + moduleName + "] tries " + "to re-define chain definition for [" + chain.getE1() + "] and [" + chain.getE2() + "] entities. Skipped.");
            }
        }
        Chains resultChains = new Chains();
        Collection resCol = availableChains.values();
        resultChains.setChain(resCol.toArray(new Chain[resCol.size()]));
        application.setContributedChains(resultChains);
    }

    private static String generateChainKey(String e1, String e2) {
        return e1 + "_" + e2;
    }
}

