/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.ant.XMLObjectsIO;
import com.queplix.contextmenu.ContextMenu;
import com.queplix.contextmenu.ContextMenuForm;
import com.queplix.contextmenu.ContextMenus;
import com.queplix.contextmenu.MenuItem;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MergeContextMenuSchema {
    public static final Logger logger = Logger.getLogger("global");

    MergeContextMenuSchema() {
    }

    public static void mergeContextMenuSchema(QApplication application) {
        logger.log(Level.INFO, "Start merging qmodules context menu metadata.");
        Set<String> modulesNames = application.getDependecyModulesOrder();
        Map<String, QModule> modules = application.getQModules();
        LinkedHashMap<String, ContextMenu> configs = new LinkedHashMap<String, ContextMenu>();
        for (String moduleName : modulesNames) {
            ContextMenu[] menus;
            QModule module = modules.get(moduleName);
            ContextMenus menuCfgs = module.getContextMenus();
            for (ContextMenu menu : menus = menuCfgs.getContextMenu()) {
                String key = menu.getName();
                ContextMenu resultPortal = configs.containsKey(key) ? MergeContextMenuSchema.mergeContextMenus((ContextMenu)configs.get(key), menu) : menu;
                configs.put(key, resultPortal);
            }
        }
        ContextMenus cfgs = new ContextMenus();
        Collection resultConfigs = configs.values();
        cfgs.setContextMenu(resultConfigs.toArray(new ContextMenu[resultConfigs.size()]));
        application.setContributedContextMenus(cfgs);
    }

    private static ContextMenu mergeContextMenus(ContextMenu baseMenu, ContextMenu derivedMenu) {
        MenuItem[] items;
        ContextMenu ret = XMLObjectsIO.cloneXMLObject(baseMenu);
        ContextMenuForm[] forms = derivedMenu.getContextMenuForm();
        if (forms != null) {
            for (ContextMenuForm form : forms) {
                ret.addContextMenuForm(form);
            }
        }
        if ((items = derivedMenu.getMenuItem()) != null) {
            for (MenuItem item : items) {
                ret.addMenuItem(item);
            }
        }
        return ret;
    }
}

