/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.messages.Messages;
import com.queplix.messages.Server;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MergeMessagesSchema {
    public static final Logger logger = Logger.getLogger("global");

    MergeMessagesSchema() {
    }

    public static void mergeMessages(QApplication application) {
        logger.log(Level.INFO, "Start merging qmodules internalization server messages metadata.");
        Set<String> modulesNames = application.getDependecyModulesOrder();
        Map<String, QModule> modules = application.getQModules();
        LinkedHashMap<String, Server> availableMessages = new LinkedHashMap<String, Server>();
        for (String moduleName : modulesNames) {
            Server[] messages;
            QModule module = modules.get(moduleName);
            for (Server message : messages = module.getMessages().getServer()) {
                String name = message.getId();
                if (availableMessages.containsKey(name)) {
                    logger.log(Level.WARNING, "Module [" + moduleName + "] re-define " + "defenition of message [" + name + "]. Replace defenition.");
                }
                availableMessages.put(name, message);
            }
        }
        Messages resultMessages = new Messages();
        Collection resCol = availableMessages.values();
        resultMessages.setServer(resCol.toArray(new Server[resCol.size()]));
        application.setContributedMessages(resultMessages);
    }
}

