/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.ant.XMLObjectsIO;
import com.queplix.portal.Control;
import com.queplix.portal.MainToolbar;
import com.queplix.portal.PortalConfig;
import com.queplix.portal.PortalConfigs;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MergePortalConfigSchema {
    public static final Logger logger = Logger.getLogger("global");

    MergePortalConfigSchema() {
    }

    public static void mergePortalConfigsSchema(QApplication application) {
        logger.log(Level.INFO, "Start merging qmodules portal configs metadata.");
        Set<String> modulesNames = application.getDependecyModulesOrder();
        Map<String, QModule> modules = application.getQModules();
        LinkedHashMap<String, PortalConfig> configs = new LinkedHashMap<String, PortalConfig>();
        for (String moduleName : modulesNames) {
            PortalConfig[] portals;
            QModule module = modules.get(moduleName);
            PortalConfigs portalConfig = module.getPortalConfigs();
            for (PortalConfig portal : portals = portalConfig.getPortalConfig()) {
                String key = portal.getName();
                PortalConfig resultPortal = configs.containsKey(key) ? MergePortalConfigSchema.mergePortalConfigs((PortalConfig)configs.get(key), portal) : portal;
                configs.put(key, resultPortal);
            }
        }
        PortalConfigs cfgs = new PortalConfigs();
        Collection resultConfigs = configs.values();
        cfgs.setPortalConfig(resultConfigs.toArray(new PortalConfig[resultConfigs.size()]));
        application.setContributedPortalConfigs(cfgs);
    }

    private static PortalConfig mergePortalConfigs(PortalConfig baseConfig, PortalConfig derivedConfig) {
        if (derivedConfig.getExtension() == null) {
            return baseConfig;
        }
        PortalConfig ret = XMLObjectsIO.cloneXMLObject(baseConfig);
        MainToolbar baseToolbar = ret.getMainToolbar();
        if (baseToolbar == null) {
            ret.setMainToolbar(derivedConfig.getMainToolbar());
        } else {
            MainToolbar derivedToolbar = derivedConfig.getMainToolbar();
            if (derivedToolbar != null) {
                Control[] controls;
                for (Control control : controls = baseToolbar.getControl()) {
                    baseToolbar.addControl(control);
                }
            }
        }
        return ret;
    }
}

