/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.contextmenu.ContextMenus;
import com.queplix.custom.Customs;
import com.queplix.dbschema.DbSchema;
import com.queplix.entity.Chains;
import com.queplix.entity.Dataschemas;
import com.queplix.entity.EntityConfig;
import com.queplix.focus.Focus;
import com.queplix.messages.Messages;
import com.queplix.portal.PortalConfigs;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class QModule {
    private String name;
    private String dir;
    private Map<String, QModule> dependsOn = new LinkedHashMap<String, QModule>();
    private DbSchema dbSchema;
    private EntityConfig entityConfig;
    private Chains chains;
    private Dataschemas dataschemas;
    private Customs customNames;
    private Messages messages;
    private List<Focus> focuses;
    private ContextMenus contextMenus;
    private PortalConfigs portalConfigs;

    public QModule(String name) {
        if (name == null || "".equalsIgnoreCase(name.trim())) {
            throw new IllegalArgumentException("Module name could not be empty.");
        }
        this.name = name.trim();
    }

    public String getName() {
        return this.name;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public Collection<QModule> getDependsOn() {
        return Collections.unmodifiableCollection(this.dependsOn.values());
    }

    public void addDependency(QModule module) {
        this.dependsOn.put(module.getName(), module);
    }

    public QModule getDependentModule(String name) {
        return this.dependsOn.get(name);
    }

    public boolean doesDepend(String name) {
        return this.name.equalsIgnoreCase(name) || this.dependsOn.containsKey(name);
    }

    public DbSchema getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(DbSchema dbSchema) {
        this.dbSchema = dbSchema;
    }

    public EntityConfig getEntityConfig() {
        return this.entityConfig;
    }

    public void setEntityConfig(EntityConfig entityConfig) {
        this.entityConfig = entityConfig;
    }

    public Chains getChains() {
        return this.chains;
    }

    public void setChains(Chains chains) {
        this.chains = chains;
    }

    public Dataschemas getDataschemas() {
        return this.dataschemas;
    }

    public void setDataschemas(Dataschemas dataschemas) {
        this.dataschemas = dataschemas;
    }

    public Customs getCustomNames() {
        return this.customNames;
    }

    public void setCustomNames(Customs customNames) {
        this.customNames = customNames;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public List<Focus> getFocuses() {
        return this.focuses;
    }

    public void setFocuses(List<Focus> focuses) {
        this.focuses = focuses;
    }

    public ContextMenus getContextMenus() {
        return this.contextMenus;
    }

    public void setContextMenus(ContextMenus contextMenus) {
        this.contextMenus = contextMenus;
    }

    public PortalConfigs getPortalConfigs() {
        return this.portalConfigs;
    }

    public void setPortalConfigs(PortalConfigs portalConfigs) {
        this.portalConfigs = portalConfigs;
    }
}

