/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.dbschema;

import com.queplix.dbschema.Custom;
import com.queplix.dbschema.Index;
import com.queplix.dbschema.Table;
import com.queplix.dbschema.View;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class DbSchema
implements Serializable {
    private ArrayList _tableList = new ArrayList();
    private ArrayList _viewList = new ArrayList();
    private ArrayList _indexList = new ArrayList();
    private Custom _custom;

    public void addIndex(Index vIndex) throws IndexOutOfBoundsException {
        this._indexList.add(vIndex);
    }

    public void addIndex(int index, Index vIndex) throws IndexOutOfBoundsException {
        this._indexList.add(index, vIndex);
    }

    public void addTable(Table vTable) throws IndexOutOfBoundsException {
        this._tableList.add(vTable);
    }

    public void addTable(int index, Table vTable) throws IndexOutOfBoundsException {
        this._tableList.add(index, vTable);
    }

    public void addView(View vView) throws IndexOutOfBoundsException {
        this._viewList.add(vView);
    }

    public void addView(int index, View vView) throws IndexOutOfBoundsException {
        this._viewList.add(index, vView);
    }

    public void clearIndex() {
        this._indexList.clear();
    }

    public void clearTable() {
        this._tableList.clear();
    }

    public void clearView() {
        this._viewList.clear();
    }

    public Enumeration enumerateIndex() {
        return new IteratorEnumeration(this._indexList.iterator());
    }

    public Enumeration enumerateTable() {
        return new IteratorEnumeration(this._tableList.iterator());
    }

    public Enumeration enumerateView() {
        return new IteratorEnumeration(this._viewList.iterator());
    }

    public Custom getCustom() {
        return this._custom;
    }

    public Index getIndex(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._indexList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Index)this._indexList.get(index);
    }

    public Index[] getIndex() {
        int size = this._indexList.size();
        Index[] mArray = new Index[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Index)this._indexList.get(index);
        }
        return mArray;
    }

    public int getIndexCount() {
        return this._indexList.size();
    }

    public Table getTable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._tableList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Table)this._tableList.get(index);
    }

    public Table[] getTable() {
        int size = this._tableList.size();
        Table[] mArray = new Table[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Table)this._tableList.get(index);
        }
        return mArray;
    }

    public int getTableCount() {
        return this._tableList.size();
    }

    public View getView(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._viewList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (View)this._viewList.get(index);
    }

    public View[] getView() {
        int size = this._viewList.size();
        View[] mArray = new View[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (View)this._viewList.get(index);
        }
        return mArray;
    }

    public int getViewCount() {
        return this._viewList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeIndex(Index vIndex) {
        boolean removed = this._indexList.remove(vIndex);
        return removed;
    }

    public boolean removeTable(Table vTable) {
        boolean removed = this._tableList.remove(vTable);
        return removed;
    }

    public boolean removeView(View vView) {
        boolean removed = this._viewList.remove(vView);
        return removed;
    }

    public void setCustom(Custom custom) {
        this._custom = custom;
    }

    public void setIndex(int index, Index vIndex) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._indexList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._indexList.set(index, vIndex);
    }

    public void setIndex(Index[] indexArray) {
        this._indexList.clear();
        for (int i = 0; i < indexArray.length; ++i) {
            this._indexList.add(indexArray[i]);
        }
    }

    public void setTable(int index, Table vTable) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._tableList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._tableList.set(index, vTable);
    }

    public void setTable(Table[] tableArray) {
        this._tableList.clear();
        for (int i = 0; i < tableArray.length; ++i) {
            this._tableList.add(tableArray[i]);
        }
    }

    public void setView(int index, View vView) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._viewList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._viewList.set(index, vView);
    }

    public void setView(View[] viewArray) {
        this._viewList.clear();
        for (int i = 0; i < viewArray.length; ++i) {
            this._viewList.add(viewArray[i]);
        }
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (DbSchema)Unmarshaller.unmarshal(DbSchema.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

