/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.ant.XMLObjectsIO;
import com.queplix.qmodule.Dependencies;
import com.queplix.qmodule.IncludingQmodule;
import com.queplix.qmodule.ModuleLocation;
import com.queplix.qmodule.QapplicationConfig;
import com.queplix.qmodule.QmoduleConfig;
import com.queplix.qmodule.Unit;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class ApplicationBuilder {
    public static final Logger logger = Logger.getLogger("global");

    ApplicationBuilder() {
    }

    public static QApplication buildApplication(String qApplicationDirectory) {
        logger.log(Level.INFO, "Build application from [" + qApplicationDirectory + "].");
        QapplicationConfig appConfig = XMLObjectsIO.loadApplication(qApplicationDirectory);
        Map<String, QmoduleConfig> modulesToBeProcessed = ApplicationBuilder.retrieveModulesConfigs(qApplicationDirectory, appConfig);
        Map<String, QModule> availableModules = ApplicationBuilder.createModules(modulesToBeProcessed, appConfig);
        List<String> naturalOrder = ApplicationBuilder.retrieveNaturalOrder(appConfig);
        ApplicationBuilder.loadModuleSchemas(availableModules, qApplicationDirectory);
        return new QApplication(availableModules, naturalOrder);
    }

    private static void loadModuleSchemas(Map<String, QModule> availableModules, String qApplicationDirectory) {
        logger.log(Level.INFO, "Load qmodule metadata configuration.");
        for (QModule module : availableModules.values()) {
            File schemaDir = new File(qApplicationDirectory, module.getDir());
            String schemasDirectory = schemaDir.getAbsolutePath();
            logger.log(Level.INFO, "Load [" + module.getName() + "] qmodule metadata config from [" + schemasDirectory + "].");
            module.setDbSchema(XMLObjectsIO.loadDBSchema(schemasDirectory));
            module.setEntityConfig(XMLObjectsIO.loadEntitySchema(schemasDirectory));
            module.setChains(XMLObjectsIO.loadChains(schemasDirectory));
            module.setDataschemas(XMLObjectsIO.loadDataschemas(schemasDirectory));
            module.setCustomNames(XMLObjectsIO.loadCustomNames(schemasDirectory));
            module.setMessages(XMLObjectsIO.loadMessages(schemasDirectory));
            module.setFocuses(XMLObjectsIO.loadFocuses(schemasDirectory));
            module.setContextMenus(XMLObjectsIO.loadContextMenus(schemasDirectory));
            module.setPortalConfigs(XMLObjectsIO.loadPortalConfigs(schemasDirectory));
        }
    }

    private static List<String> retrieveNaturalOrder(QapplicationConfig appConfig) {
        ModuleLocation[] locations;
        LinkedList<String> order = new LinkedList<String>();
        for (ModuleLocation location : locations = appConfig.getConfig().getModuleLocation()) {
            order.add(location.getName());
        }
        return order;
    }

    private static Map<String, QModule> createModules(Map<String, QmoduleConfig> modulesToBeProcessed, QapplicationConfig appConfig) {
        ModuleLocation[] locations;
        HashMap<String, QModule> availableModules = new HashMap<String, QModule>();
        for (String moduleName : modulesToBeProcessed.keySet()) {
            availableModules.put(moduleName, new QModule(moduleName));
        }
        for (String moduleName : modulesToBeProcessed.keySet()) {
            IncludingQmodule[] includingModules;
            QmoduleConfig moduleConfig = modulesToBeProcessed.get(moduleName);
            QModule module = (QModule)availableModules.get(moduleName);
            Dependencies dependencies = moduleConfig.getDependencies();
            if (dependencies == null) continue;
            for (IncludingQmodule qmodule : includingModules = dependencies.getIncludingQmodule()) {
                module.addDependency((QModule)availableModules.get(qmodule.getName()));
            }
        }
        for (ModuleLocation location : locations = appConfig.getConfig().getModuleLocation()) {
            ((QModule)availableModules.get(location.getName())).setDir(location.getDir());
        }
        return availableModules;
    }

    private static Map<String, QmoduleConfig> retrieveModulesConfigs(String qApplicationDirectory, QapplicationConfig appConfig) {
        Unit[] units;
        ModuleLocation[] availableLocations;
        logger.log(Level.INFO, "Load qmodules configs.");
        HashMap<String, String> existingModulesConfigs = new HashMap<String, String>();
        for (ModuleLocation location : availableLocations = appConfig.getConfig().getModuleLocation()) {
            existingModulesConfigs.put(location.getName(), location.getDir());
        }
        LinkedHashMap<String, QmoduleConfig> processingQModules = new LinkedHashMap<String, QmoduleConfig>();
        for (Unit unit : units = appConfig.getDeploy().getUnit()) {
            IncludingQmodule[] includingModules;
            for (IncludingQmodule module : includingModules = unit.getIncludingQmodule()) {
                String moduleName = module.getName();
                if (processingQModules.containsKey(moduleName)) continue;
                String relativeToApplicationModuleDir = (String)existingModulesConfigs.get(moduleName);
                if (relativeToApplicationModuleDir == null) {
                    throw new IllegalStateException("QApplication descriptor file doesn't contain \"config->module-location\" element for module [" + moduleName + "].");
                }
                String absoluteModuleDir = new File(qApplicationDirectory, relativeToApplicationModuleDir).getAbsolutePath();
                logger.log(Level.INFO, "Load qmodule [" + moduleName + "].");
                QmoduleConfig moduleConfig = XMLObjectsIO.loadQModule(absoluteModuleDir);
                processingQModules.put(moduleName, moduleConfig);
            }
        }
        return processingQModules;
    }
}

