/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.BaseViewNode;
import com.queplix.ant.EmptyViewNode;
import com.queplix.ant.StringHelper;
import com.queplix.ant.ViewNode;
import com.queplix.ant.ViewNodeType;
import com.queplix.ant.XMLObjectsIO;
import com.queplix.focus.Button;
import com.queplix.focus.Buttons;
import com.queplix.focus.Caption;
import com.queplix.focus.Captions;
import com.queplix.focus.Col;
import com.queplix.focus.ExtLayout;
import com.queplix.focus.Extension;
import com.queplix.focus.Field;
import com.queplix.focus.Form;
import com.queplix.focus.Htmlelement;
import com.queplix.focus.Htmlelements;
import com.queplix.focus.Layout;
import com.queplix.focus.Row;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class FormViewNode
extends BaseViewNode<Form, EmptyViewNode> {
    public static final Logger logger = Logger.getLogger("global");
    private static final Button[] DEFAULT_BUTTONS = new Button[]{FormViewNode.createButton("FORM_SEARCH_BUTTON"), FormViewNode.createButton("FORM_CLEAR_BUTTON"), FormViewNode.createButton("FORM_NEW_BUTTON"), FormViewNode.createButton("FORM_CHANGE_OR_UPDATE_BUTTON")};

    public FormViewNode(String localName, int order, Form viewObject) {
        super(localName, order, ViewNodeType.form, viewObject);
    }

    @Override
    public void mergeObjects(ViewNode<Form, EmptyViewNode> viewNode) {
        Row[] rows;
        Form baseForm = (Form)this.getInitialViewObject();
        Form derivedForm = viewNode.getViewObject();
        Extension extensionElement = derivedForm.getExtension();
        if (extensionElement == null) {
            return;
        }
        HashSet<String> buttonsIds = new HashSet<String>();
        Buttons baseButtons = baseForm.getButtons();
        if (baseButtons == null || baseButtons.getDefaultactions().booleanValue()) {
            baseButtons = new Buttons();
            baseButtons.setButton(DEFAULT_BUTTONS);
            baseForm.setButtons(baseButtons);
        }
        for (Button button : baseButtons.getButton()) {
            buttonsIds.add(button.getName());
        }
        Buttons derivedButtons = extensionElement.getButtons();
        for (Button button : derivedButtons.getButton()) {
            if (buttonsIds.contains(button.getName())) {
                logger.log(Level.WARNING, "Form with name [" + this.getLocalName() + "] tries to re-define button [" + button.getName() + "]. Defenition skipped.");
                continue;
            }
            baseButtons.addButton(button);
        }
        HashSet<String> htmlIds = new HashSet<String>();
        Htmlelements baseHtmls = baseForm.getHtmlelements();
        if (baseHtmls != null) {
            for (Htmlelement html : baseHtmls.getHtmlelement()) {
                htmlIds.add(html.getName());
            }
        } else {
            baseHtmls = new Htmlelements();
            baseForm.setHtmlelements(baseHtmls);
        }
        Htmlelements derivedHtmls = extensionElement.getHtmlelements();
        for (Htmlelement html : derivedHtmls.getHtmlelement()) {
            if (htmlIds.contains(html.getName())) {
                logger.log(Level.WARNING, "Form with name [" + this.getLocalName() + "] tries to re-define html element [" + html.getName() + "]. Defenition skipped.");
                continue;
            }
            baseHtmls.addHtmlelement(html);
        }
        Layout layout = baseForm.getLayout();
        ExtLayout layoutExtension = extensionElement.getExtLayout();
        if (layout != null && layoutExtension != null && (rows = layout.getRow()) != null) {
            Field[] fields;
            for (Field field : fields = layoutExtension.getField()) {
                this.addField(layout, field);
            }
        }
    }

    private void addField(Layout layout, Field field) {
        int prefferedRow = field.getRow();
        int prefferedCol = field.getCol();
        Col col = new Col();
        col.setFieldid(field.getFieldid());
        col.setColspan(field.getColSpan());
        col.setRowspan(field.getRowSpan());
        if (prefferedRow >= layout.getRow().length) {
            Row row = new Row();
            row.addCol(col);
            layout.addRow(row);
        } else {
            Row targetRow = layout.getRow()[prefferedRow];
            if (this.isRowOccupied(targetRow, prefferedCol)) {
                targetRow.addCol(col);
            } else {
                targetRow.setCol(prefferedCol, col);
            }
        }
    }

    private boolean isRowOccupied(Row targetRow, int prefferedCol) {
        if (prefferedCol > 0) {
            Col previousCol = targetRow.getCol(prefferedCol - 1);
            Integer colspan = previousCol.getColspan();
            int intColspan = colspan != null ? colspan : 1;
            Col addingCol = targetRow.getCol(prefferedCol);
            return StringHelper.isEmpty(addingCol.getFieldid()) && intColspan > 1;
        }
        return true;
    }

    @Override
    public List<EmptyViewNode> createChildren(Form object) {
        return Collections.emptyList();
    }

    @Override
    public Form getViewObject() {
        return (Form)XMLObjectsIO.cloneXMLObject(this.getInitialViewObject());
    }

    private static Button createButton(String buttonName) {
        Button button = new Button();
        button.setName(buttonName);
        Captions caps = new Captions();
        Caption cap = new Caption();
        caps.addCaption(cap);
        button.setCaptions(caps);
        return button;
    }
}

