/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.dbschema;

import com.queplix.dbschema.Column;
import com.queplix.dbschema.TableConstraints;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Table
implements Serializable {
    private String _name;
    private ArrayList _columnList = new ArrayList();
    private TableConstraints _tableConstraints;

    public void addColumn(Column vColumn) throws IndexOutOfBoundsException {
        this._columnList.add(vColumn);
    }

    public void addColumn(int index, Column vColumn) throws IndexOutOfBoundsException {
        this._columnList.add(index, vColumn);
    }

    public void clearColumn() {
        this._columnList.clear();
    }

    public Enumeration enumerateColumn() {
        return new IteratorEnumeration(this._columnList.iterator());
    }

    public Column getColumn(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._columnList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Column)this._columnList.get(index);
    }

    public Column[] getColumn() {
        int size = this._columnList.size();
        Column[] mArray = new Column[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Column)this._columnList.get(index);
        }
        return mArray;
    }

    public int getColumnCount() {
        return this._columnList.size();
    }

    public String getName() {
        return this._name;
    }

    public TableConstraints getTableConstraints() {
        return this._tableConstraints;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeColumn(Column vColumn) {
        boolean removed = this._columnList.remove(vColumn);
        return removed;
    }

    public void setColumn(int index, Column vColumn) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._columnList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._columnList.set(index, vColumn);
    }

    public void setColumn(Column[] columnArray) {
        this._columnList.clear();
        for (int i = 0; i < columnArray.length; ++i) {
            this._columnList.add(columnArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setTableConstraints(TableConstraints tableConstraints) {
        this._tableConstraints = tableConstraints;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Table)Unmarshaller.unmarshal(Table.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

