/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.dbschema.types;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class SqlDataType
implements Serializable {
    public static final int STRING_TYPE = 0;
    public static final SqlDataType STRING = new SqlDataType(0, "string");
    public static final int INT_TYPE = 1;
    public static final SqlDataType INT = new SqlDataType(1, "int");
    public static final int LONG_TYPE = 2;
    public static final SqlDataType LONG = new SqlDataType(2, "long");
    public static final int FLOAT_TYPE = 3;
    public static final SqlDataType FLOAT = new SqlDataType(3, "float");
    public static final int TIME_TYPE = 4;
    public static final SqlDataType TIME = new SqlDataType(4, "time");
    public static final int DATE_TYPE = 5;
    public static final SqlDataType DATE = new SqlDataType(5, "date");
    public static final int TIMESTAMP_TYPE = 6;
    public static final SqlDataType TIMESTAMP = new SqlDataType(6, "timestamp");
    public static final int MEMO_TYPE = 7;
    public static final SqlDataType MEMO = new SqlDataType(7, "memo");
    public static final int BINARY_TYPE = 8;
    public static final SqlDataType BINARY = new SqlDataType(8, "binary");
    private static Hashtable _memberTable = SqlDataType.init();
    private int type = -1;
    private String stringValue = null;

    private SqlDataType(int type, String value) {
        this.type = type;
        this.stringValue = value;
    }

    public static Enumeration enumerate() {
        return _memberTable.elements();
    }

    public int getType() {
        return this.type;
    }

    private static Hashtable init() {
        Hashtable<String, SqlDataType> members = new Hashtable<String, SqlDataType>();
        members.put("string", STRING);
        members.put("int", INT);
        members.put("long", LONG);
        members.put("float", FLOAT);
        members.put("time", TIME);
        members.put("date", DATE);
        members.put("timestamp", TIMESTAMP);
        members.put("memo", MEMO);
        members.put("binary", BINARY);
        return members;
    }

    private Object readResolve() {
        return SqlDataType.valueOf(this.stringValue);
    }

    public String toString() {
        return this.stringValue;
    }

    public static SqlDataType valueOf(String string) {
        Object obj = null;
        if (string != null) {
            obj = _memberTable.get(string);
        }
        if (obj == null) {
            String err = "'" + string + "' is not a valid SqlDataType";
            throw new IllegalArgumentException(err);
        }
        return obj;
    }
}

