/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.ViewNode;
import com.queplix.ant.ViewNodeType;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

abstract class BaseViewNode<T, E extends ViewNode>
implements ViewNode<T, E> {
    private int order;
    private String localName;
    private ViewNodeType type;
    private T viewObject;
    private Set<E> orderedChildren = new TreeSet(new Comparator<E>(){

        @Override
        public int compare(E o1, E o2) {
            int i = o2.getOrder() - o1.getOrder();
            return i == 0 ? 1 : i;
        }
    });
    private Map<String, E> children = new HashMap<String, E>();

    public BaseViewNode(String localName, int order, ViewNodeType type, T viewObject) {
        this.order = order;
        this.localName = localName;
        this.type = type;
        this.viewObject = viewObject;
        List children = this.createChildren(viewObject);
        for (ViewNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public ViewNodeType getType() {
        return this.type;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public void addChild(E child) {
        ViewNode baseChild = (ViewNode)this.children.get(child.getLocalName());
        if (baseChild != null) {
            baseChild.mergeObjects(child);
        } else {
            this.children.put(child.getLocalName(), child);
            this.orderedChildren.add(child);
        }
    }

    @Override
    public Set<E> getChildren() {
        return this.orderedChildren;
    }

    protected T getInitialViewObject() {
        return this.viewObject;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void mergeObjects(ViewNode<T, E> node) {
        if (!node.getType().equals((Object)this.getType())) {
            throw new IllegalArgumentException("Could not merges objects, types are mistmatch.");
        }
    }
}

