/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.StringHelper;
import com.queplix.entity.Entity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class EntityLevel {
    public static final String ENTITY_NAME_SEPARATOR = ".";
    private String localName;
    private EntityLevel parentLevel;
    private Entity nodeEntity;
    private Map<String, EntityLevel> children = new LinkedHashMap<String, EntityLevel>();

    public EntityLevel(String localName, EntityLevel parentLevel) {
        this.localName = localName;
        this.parentLevel = parentLevel;
    }

    public void addNode(String currentLevelFullName, Entity entity) {
        String nextLevelName;
        String localNodeName = EntityLevel.extractFirstLocalName(currentLevelFullName);
        EntityLevel level = this.children.get(localNodeName);
        if (level == null) {
            level = new EntityLevel(localNodeName, this);
            this.children.put(localNodeName, level);
        }
        if (StringHelper.isEmpty(nextLevelName = EntityLevel.extractNextLevelName(currentLevelFullName))) {
            level.setNodeEntity(entity);
        } else {
            level.addNode(nextLevelName, entity);
        }
    }

    public List<Entity> getEntity() {
        Collection<EntityLevel> values = this.children.values();
        LinkedList<Entity> childEntities = new LinkedList<Entity>();
        for (EntityLevel level : values) {
            List<Entity> entities = level.getEntity();
            childEntities.addAll(entities);
        }
        if (this.nodeEntity != null) {
            this.nodeEntity.setName(this.getEmptyRangeEntityName());
            this.nodeEntity.setEntity(childEntities.toArray(new Entity[childEntities.size()]));
            ArrayList<Entity> result = new ArrayList<Entity>(1);
            result.add(this.nodeEntity);
            return result;
        }
        return childEntities;
    }

    protected String getEmptyRangeEntityName() {
        String parentEmptyRangeName;
        String ret = this.parentLevel == null ? this.localName : (this.parentLevel.nodeEntity != null ? this.localName : (StringHelper.isEmpty(parentEmptyRangeName = this.parentLevel.getEmptyRangeEntityName()) ? this.localName : parentEmptyRangeName + ENTITY_NAME_SEPARATOR + this.localName));
        return ret;
    }

    private Entity getFirstAvailableEntityNode() {
        return this.nodeEntity != null ? this.nodeEntity : (this.parentLevel != null ? this.parentLevel.getFirstAvailableEntityNode() : null);
    }

    public String getLocalName() {
        return this.localName;
    }

    public EntityLevel getParentLevel() {
        return this.parentLevel;
    }

    public Entity getNodeEntity() {
        return this.nodeEntity;
    }

    public void setNodeEntity(Entity nodeEntity) {
        this.nodeEntity = nodeEntity;
    }

    public Map<String, EntityLevel> getChildren() {
        return this.children;
    }

    private static String extractFirstLocalName(String name) {
        int idx = name.indexOf(ENTITY_NAME_SEPARATOR);
        int end = idx != -1 ? idx : name.length();
        return name.substring(0, end);
    }

    private static String extractNextLevelName(String name) {
        int idx = name.indexOf(ENTITY_NAME_SEPARATOR);
        String ret = idx >= 0 ? name.substring(idx + 1) : "";
        return ret;
    }
}

