/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.custom.Custom;
import com.queplix.custom.Customs;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MergeCustomSchema {
    public static final Logger logger = Logger.getLogger("global");

    MergeCustomSchema() {
    }

    public static void mergeCustomSchema(QApplication application) {
        logger.log(Level.INFO, "Start merging qmodules internalization captions metadata.");
        Set<String> modulesNames = application.getDependecyModulesOrder();
        Map<String, QModule> modules = application.getQModules();
        LinkedHashMap<String, Custom> availableCustoms = new LinkedHashMap<String, Custom>();
        for (String moduleName : modulesNames) {
            Custom[] Customs2;
            QModule module = modules.get(moduleName);
            for (Custom custom : Customs2 = module.getCustomNames().getCustom()) {
                String entity = custom.getEntity();
                if (availableCustoms.containsKey(entity)) {
                    logger.log(Level.WARNING, "Module [" + moduleName + "] re-define " + "labels for entity [" + entity + "]. Labels is replaced.");
                }
                availableCustoms.put(entity, custom);
            }
        }
        Customs resultCustoms = new Customs();
        Collection resCol = availableCustoms.values();
        resultCustoms.setCustom(resCol.toArray(new Custom[resCol.size()]));
        application.setContributedCustomNames(resultCustoms);
    }
}

