/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.ant.StringHelper;
import com.queplix.dbschema.Based;
import com.queplix.dbschema.Cluster;
import com.queplix.dbschema.Column;
import com.queplix.dbschema.Custom;
import com.queplix.dbschema.DbSchema;
import com.queplix.dbschema.Foreign;
import com.queplix.dbschema.Index;
import com.queplix.dbschema.Join;
import com.queplix.dbschema.Joins;
import com.queplix.dbschema.Primary;
import com.queplix.dbschema.RefColumn;
import com.queplix.dbschema.RefTable;
import com.queplix.dbschema.Script;
import com.queplix.dbschema.Table;
import com.queplix.dbschema.TableConstraints;
import com.queplix.dbschema.View;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MergeDBSchema {
    public static final Logger logger = Logger.getLogger("global");

    MergeDBSchema() {
    }

    public static void mergeDBSchema(QApplication application) {
        logger.log(Level.INFO, "Start merging qmodules DB metadata.");
        DbSchema resultSchema = new DbSchema();
        Set<String> modulesNames = application.getDependecyModulesOrder();
        Map<String, QModule> modules = application.getQModules();
        LinkedHashMap<String, Table> mergedTables = new LinkedHashMap<String, Table>();
        LinkedHashMap<String, View> mergedViews = new LinkedHashMap<String, View>();
        LinkedHashMap<String, Index> mergedIndexes = new LinkedHashMap<String, Index>();
        LinkedHashSet<String> mergedCustomScripts = new LinkedHashSet<String>();
        for (String moduleName : modulesNames) {
            String[] scriptGuids;
            Index[] indexes;
            View[] views;
            Table[] tables;
            QModule module = modules.get(moduleName);
            DbSchema moduleSchema = module.getDbSchema();
            if (moduleSchema == null) continue;
            for (Table table : tables = moduleSchema.getTable()) {
                Table resultTable = mergedTables.containsKey(table.getName()) ? MergeDBSchema.mergeTables((Table)mergedTables.get(table.getName()), table) : table;
                mergedTables.put(table.getName(), resultTable);
            }
            for (View view : views = moduleSchema.getView()) {
                View resultView = mergedViews.containsKey(view.getName()) ? MergeDBSchema.mergeViews((View)mergedViews.get(view.getName()), view) : view;
                mergedViews.put(view.getName(), resultView);
            }
            for (Index index : indexes = moduleSchema.getIndex()) {
                if (mergedIndexes.containsKey(index.getName())) {
                    throw new IllegalArgumentException("Index name [" + index.getName() + "] occured more then once.");
                }
                mergedIndexes.put(index.getName(), index);
            }
            for (String guid : scriptGuids = moduleSchema.getCustom().getScript().getGuid()) {
                if (mergedCustomScripts.add(guid)) continue;
                throw new IllegalArgumentException("Error, the same guid [" + guid + "] is defined twice. Rename custom script " + "name or remove duplicate.");
            }
        }
        Collection tablesCollection = mergedTables.values();
        resultSchema.setTable(tablesCollection.toArray(new Table[tablesCollection.size()]));
        Collection viewsCollection = mergedViews.values();
        resultSchema.setView(viewsCollection.toArray(new View[viewsCollection.size()]));
        Collection indexesCollection = mergedIndexes.values();
        resultSchema.setIndex(indexesCollection.toArray(new Index[indexesCollection.size()]));
        Custom custom = new Custom();
        Script script = new Script();
        script.setGuid(mergedCustomScripts.toArray(new String[mergedCustomScripts.size()]));
        custom.setScript(script);
        resultSchema.setCustom(custom);
        application.setContributedDBSchema(resultSchema);
    }

    private static Table mergeTables(Table baseTable, Table derivedTable) {
        Foreign[] derivedForeigns;
        Column[] additionalColumns;
        Column[] columns;
        Table result = new Table();
        LinkedHashMap<String, Column> resColumns = new LinkedHashMap<String, Column>();
        for (Column column : columns = baseTable.getColumn()) {
            if (resColumns.containsKey(column.getName())) {
                throw new IllegalStateException("Table [" + baseTable.getName() + "] contains two definition of column [" + column.getName() + "].");
            }
            resColumns.put(column.getName(), column);
        }
        for (Column column : additionalColumns = derivedTable.getColumn()) {
            if (resColumns.containsKey(column.getName())) {
                Column baseColumn = (Column)resColumns.get(column.getName());
                if (!MergeDBSchema.isColumnsEqual(baseColumn, column)) {
                    throw new IllegalStateException("Table [" + baseTable.getName() + "] contains two different definition of same column [" + column.getName() + "] in different modules.");
                }
                resColumns.put(column.getName(), column);
                continue;
            }
            resColumns.put(column.getName(), column);
        }
        Collection columnsCollection = resColumns.values();
        result.setColumn(columnsCollection.toArray(new Column[columnsCollection.size()]));
        TableConstraints baseConstraints = baseTable.getTableConstraints();
        Primary basePrimary = baseConstraints.getPrimary();
        Foreign[] baseForeign = baseConstraints.getForeign();
        LinkedHashMap<String, Foreign> mergedConstr = new LinkedHashMap<String, Foreign>();
        for (Foreign foreign : baseForeign) {
            mergedConstr.put(foreign.getName(), foreign);
        }
        TableConstraints derivedConstraints = derivedTable.getTableConstraints();
        Primary derivedPrimary = derivedConstraints.getPrimary();
        if (derivedPrimary != null) {
            logger.log(Level.WARNING, "Derived table [" + derivedTable.getName() + "] tries to re-defind primary key constraint [" + derivedPrimary.getName() + "]. We don't allow to do that.");
        }
        for (Foreign derivedForeign : derivedForeigns = derivedConstraints.getForeign()) {
            if (mergedConstr.containsKey(derivedForeign.getName())) {
                throw new IllegalStateException("Derived table [" + derivedTable.getName() + "] tries to re-define foreign constraint with the " + "name that is already present in table.");
            }
            mergedConstr.put(derivedForeign.getName(), derivedForeign);
        }
        TableConstraints mergedConstraints = new TableConstraints();
        mergedConstraints.setPrimary(basePrimary);
        Collection foreignCollection = mergedConstr.values();
        mergedConstraints.setForeign(foreignCollection.toArray(new Foreign[foreignCollection.size()]));
        result.setTableConstraints(mergedConstraints);
        return result;
    }

    private static View mergeViews(View baseView, View derivedView) {
        View resultView = new View();
        LinkedHashMap<String, Cluster> resultClusters = new LinkedHashMap<String, Cluster>();
        for (Cluster cluster : baseView.getCluster()) {
            resultClusters.put(cluster.getName(), cluster);
        }
        for (Cluster cluster : derivedView.getCluster()) {
            Cluster mergedCluster = resultClusters.containsKey(cluster.getName()) ? MergeDBSchema.mergeClusters((Cluster)resultClusters.get(cluster.getName()), cluster, baseView.getName()) : cluster;
            resultClusters.put(cluster.getName(), mergedCluster);
        }
        Collection clustersCollection = resultClusters.values();
        resultView.setCluster(clustersCollection.toArray(new Cluster[clustersCollection.size()]));
        return resultView;
    }

    private static Cluster mergeClusters(Cluster baseCluster, Cluster derivedCluster, String viewName) {
        RefTable[] refTables;
        if (baseCluster.getType().getType() != derivedCluster.getType().getType()) {
            throw new IllegalStateException("Could not join cluster [" + baseCluster.getName() + "] in view [" + viewName + "] because those have different types.");
        }
        Cluster resultCluster = new Cluster();
        LinkedHashMap<String, RefTable> resultRefTables = new LinkedHashMap<String, RefTable>();
        Based basedSection = resultCluster.getBased();
        for (RefTable refTable : refTables = basedSection.getRefTable()) {
            resultRefTables.put(refTable.getName(), refTable);
        }
        for (RefTable refTable : derivedCluster.getBased().getRefTable()) {
            RefTable mergedRefTable = resultRefTables.containsKey(refTable.getName()) ? MergeDBSchema.mergeRefTables((RefTable)resultRefTables.get(refTable.getName()), refTable, baseCluster.getName(), viewName) : refTable;
            resultRefTables.put(refTable.getName(), mergedRefTable);
        }
        Based based = new Based();
        Collection basedCollection = resultRefTables.values();
        based.setRefTable(basedCollection.toArray(new RefTable[basedCollection.size()]));
        resultCluster.setBased(based);
        HashSet<Join> joins = new HashSet<Join>();
        for (Join join : baseCluster.getJoins().getJoin()) {
            joins.add(join);
        }
        for (Join join : derivedCluster.getJoins().getJoin()) {
            joins.add(join);
        }
        Joins joinSection = new Joins();
        joinSection.setJoin(joins.toArray(new Join[joins.size()]));
        resultCluster.setJoins(joinSection);
        return resultCluster;
    }

    private static RefTable mergeRefTables(RefTable baseRefTable, RefTable derivedRefTable, String clusterName, String viewName) {
        RefColumn[] baseColumns;
        RefTable resultTable = new RefTable();
        LinkedHashMap<String, RefColumn> resultColumns = new LinkedHashMap<String, RefColumn>();
        for (RefColumn baseColumn : baseColumns = baseRefTable.getRefColumn()) {
            resultColumns.put(baseColumn.getName(), baseColumn);
        }
        for (RefColumn derivedColumn : derivedRefTable.getRefColumn()) {
            if (resultColumns.containsKey(derivedColumn.getName())) {
                RefColumn baseColumn = (RefColumn)resultColumns.get(derivedColumn.getName());
                String as = baseColumn.getAs();
                if (StringHelper.stringEquals(as, derivedColumn.getAs())) continue;
                throw new IllegalStateException("View [" + viewName + "], " + " cluster [" + clusterName + "], base table [" + baseRefTable + "], column [" + baseColumn + "] has different aliases for it in different " + "qmodules.");
            }
            resultColumns.put(derivedColumn.getName(), derivedColumn);
        }
        Collection tablesCollection = resultColumns.values();
        resultTable.setRefColumn(tablesCollection.toArray(new RefColumn[tablesCollection.size()]));
        return resultTable;
    }

    private static boolean isColumnsEqual(Column c1, Column c2) {
        boolean nullableEq = c1.getNullable() != null ? c1.getNullable().equals(c2.getNullable()) : c1.getNullable() == c2.getNullable();
        boolean defEq = StringHelper.stringEquals(c1.getDefault(), c2.getDefault());
        boolean typesEq = c1.getType().getType() == c2.getType().getType();
        return nullableEq && defEq && typesEq;
    }
}

