/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.entity.Dataschema;
import com.queplix.entity.Dataschemas;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MergeDataShema {
    public static final Logger logger = Logger.getLogger("global");

    MergeDataShema() {
    }

    public static void mergeDataSchema(QApplication application) {
        logger.log(Level.INFO, "Start merging qmodules dataschema metadata.");
        Set<String> modulesNames = application.getDependecyModulesOrder();
        Map<String, QModule> modules = application.getQModules();
        LinkedHashMap<String, Dataschema> availableDataschemas = new LinkedHashMap<String, Dataschema>();
        for (String moduleName : modulesNames) {
            Dataschema[] Dataschemas2;
            QModule module = modules.get(moduleName);
            for (Dataschema dataschema : Dataschemas2 = module.getDataschemas().getDataschema()) {
                String name = dataschema.getName();
                if (!availableDataschemas.containsKey(name)) {
                    availableDataschemas.put(name, dataschema);
                    continue;
                }
                logger.log(Level.WARNING, "Module [" + moduleName + "] tries " + "to re-define dataschema defenition with name [" + name + "]. Skipped.");
            }
        }
        Dataschemas resultDataschemas = new Dataschemas();
        Collection resCol = availableDataschemas.values();
        resultDataschemas.setDataschema(resCol.toArray(new Dataschema[resCol.size()]));
        application.setContributedDataschemas(resultDataschemas);
    }
}

