/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.EntityLevel;
import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.ant.StringHelper;
import com.queplix.ant.XMLObjectsIO;
import com.queplix.entity.Afterdelete;
import com.queplix.entity.Afternew;
import com.queplix.entity.Afterupdate;
import com.queplix.entity.Beforedelete;
import com.queplix.entity.Beforeupdate;
import com.queplix.entity.Dataset;
import com.queplix.entity.Delete;
import com.queplix.entity.Efield;
import com.queplix.entity.Entity;
import com.queplix.entity.EntityConfig;
import com.queplix.entity.Fkeys;
import com.queplix.entity.Scripts;
import com.queplix.entity.Update;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class MergeEntitySchema {
    public static final Logger logger = Logger.getLogger("global");
    private static final String ENTITY_LEVELS_DIVIDER = ".";
    private static final String AND_EQL_CLAUSE = " and ";
    private static final String ASC_EQL_CLAUSE = "asc";
    private static final String DESC_EQL_CLAUSE = "desc";

    MergeEntitySchema() {
    }

    public static void mergeEntitySchema(QApplication application) {
        logger.log(Level.INFO, "Start merging qmodules entities metadata.");
        Set<String> modulesNames = application.getDependecyModulesOrder();
        Map<String, QModule> modules = application.getQModules();
        LinkedHashMap<String, Entity> availableEntities = new LinkedHashMap<String, Entity>();
        for (String moduleName : modulesNames) {
            QModule module = modules.get(moduleName);
            EntityConfig moduleEntitySchema = XMLObjectsIO.cloneXMLObject(module.getEntityConfig());
            Entity[] entities = moduleEntitySchema.getEntity();
            MergeEntitySchema.addEntities(entities, availableEntities, "");
        }
        application.setContributedEntityConfig(MergeEntitySchema.buildHeritageStructure(availableEntities));
    }

    private static EntityConfig buildHeritageStructure(Map<String, Entity> availableEntities) {
        EntityConfig resultConfig = new EntityConfig();
        EntityLevel baseLevel = new EntityLevel("", null);
        Set<String> keys = availableEntities.keySet();
        for (String key : keys) {
            baseLevel.addNode(key, availableEntities.get(key));
        }
        List<Entity> entities = baseLevel.getEntity();
        resultConfig.setEntity(entities.toArray(new Entity[entities.size()]));
        return resultConfig;
    }

    private static void addEntities(Entity[] entities, Map<String, Entity> availableEntities, String namePrefix) {
        for (Entity entity : entities) {
            String entityName = namePrefix + entity.getName();
            Entity resultEntity = availableEntities.containsKey(entityName) ? MergeEntitySchema.mergeEntities(availableEntities.get(entityName), entity) : entity;
            availableEntities.put(entityName, resultEntity);
            Entity[] childEntities = entity.getEntity();
            MergeEntitySchema.addEntities(childEntities, availableEntities, entityName + ENTITY_LEVELS_DIVIDER);
        }
    }

    private static Entity mergeEntities(Entity baseEntity, Entity derivedEntity) {
        Dataset[] baseDatasets;
        Dataset[] derivedDatasets;
        Efield[] baseFields;
        Efield[] derivedFields;
        if (!StringHelper.stringEquals(baseEntity.getDbobject(), derivedEntity.getDbobject())) {
            throw new IllegalArgumentException("Entities " + derivedEntity.getName() + "have same names " + "and different database object.");
        }
        Entity resultEntity = XMLObjectsIO.cloneXMLObject(baseEntity);
        LinkedHashMap<String, Efield> efields = new LinkedHashMap<String, Efield>();
        for (Efield field : derivedFields = derivedEntity.getEfield()) {
            efields.put(field.getName(), field);
        }
        for (Efield field : baseFields = baseEntity.getEfield()) {
            if (efields.containsKey(field.getName())) {
                logger.log(Level.WARNING, "Field [" + field.getName() + "] could " + "not be re-defined in other modules, you can " + "only add another field.");
                continue;
            }
            efields.put(field.getName(), field);
        }
        Collection efieldsCol = efields.values();
        resultEntity.setEfield(efieldsCol.toArray(new Efield[efieldsCol.size()]));
        LinkedHashMap<String, Dataset> datasets = new LinkedHashMap<String, Dataset>();
        for (Dataset field : derivedDatasets = derivedEntity.getDataset()) {
            datasets.put(field.getName(), field);
        }
        for (Dataset dataset : baseDatasets = baseEntity.getDataset()) {
            if (datasets.containsKey(dataset.getName())) {
                logger.log(Level.WARNING, "Dataset [" + dataset.getName() + "] could " + "not be re-defined in other modules, you can " + "only add another dataset.");
                continue;
            }
            datasets.put(dataset.getName(), dataset);
        }
        Collection datasetsCol = datasets.values();
        resultEntity.setDataset(datasetsCol.toArray(new Dataset[datasetsCol.size()]));
        List<Fkeys> fkeys = MergeEntitySchema.combineArrays(derivedEntity.getFkeys(), baseEntity.getFkeys());
        resultEntity.setFkeys(fkeys.toArray(new Fkeys[fkeys.size()]));
        Scripts baseScripts = baseEntity.getScripts();
        Scripts derivedScripts = derivedEntity.getScripts();
        resultEntity.setScripts(MergeEntitySchema.mergeScripts(baseScripts, derivedScripts));
        String baseOrder = baseEntity.getEqlOrder();
        String derivedOrder = derivedEntity.getEqlOrder();
        if (!StringHelper.isEmpty(baseOrder) && !StringHelper.isEmpty(derivedOrder)) {
            resultEntity.setEqlOrder(MergeEntitySchema.combineOrderClauses(baseOrder, derivedOrder));
        } else if (!StringHelper.isEmpty(derivedOrder)) {
            resultEntity.setEqlOrder(derivedOrder);
        }
        String baseConstr = baseEntity.getEqlConstraint();
        String derivedConstr = derivedEntity.getEqlConstraint();
        if (!StringHelper.isEmpty(baseConstr) && !StringHelper.isEmpty(derivedConstr)) {
            resultEntity.setEqlConstraint(baseConstr + AND_EQL_CLAUSE + derivedConstr);
        } else if (!StringHelper.isEmpty(derivedConstr)) {
            resultEntity.setEqlConstraint(derivedConstr);
        }
        return resultEntity;
    }

    private static String combineOrderClauses(String baseOrder, String derivedOrder) {
        String baseFields = MergeEntitySchema.getFieldsWithoutOrderDirection(baseOrder.toLowerCase());
        String baseDirection = MergeEntitySchema.getOrderDirection(baseOrder.toLowerCase());
        String derivedFields = MergeEntitySchema.getFieldsWithoutOrderDirection(derivedOrder.toLowerCase());
        return baseFields + "," + derivedFields + " " + baseDirection;
    }

    private static String getOrderDirection(String order) {
        boolean endsWithAsc = order.endsWith(ASC_EQL_CLAUSE);
        boolean endsWithDesc = order.endsWith(DESC_EQL_CLAUSE);
        if (!endsWithAsc && !endsWithDesc) {
            endsWithAsc = true;
        }
        return endsWithAsc ? ASC_EQL_CLAUSE : DESC_EQL_CLAUSE;
    }

    private static String getFieldsWithoutOrderDirection(String order) {
        boolean endsWithAsc = order.endsWith(ASC_EQL_CLAUSE);
        boolean endsWithDesc = order.endsWith(DESC_EQL_CLAUSE);
        String ret = order;
        if (endsWithAsc) {
            ret = ret.substring(0, order.indexOf(ASC_EQL_CLAUSE));
        } else if (endsWithDesc) {
            ret = ret.substring(0, order.indexOf(DESC_EQL_CLAUSE));
        }
        return ret;
    }

    public static void main(String[] args) {
        System.out.println(MergeEntitySchema.combineOrderClauses("$entity.chart_id DESC", "$entity.account_name ASC"));
    }

    private static Scripts mergeScripts(Scripts baseScripts, Scripts derivedScripts) {
        Scripts resultScripts = new Scripts();
        if (baseScripts != null) {
            if (derivedScripts != null) {
                List<Afterdelete> afterdeletes = MergeEntitySchema.combineArrays(baseScripts.getAfterdelete(), derivedScripts.getAfterdelete());
                resultScripts.setAfterdelete(afterdeletes.toArray(new Afterdelete[afterdeletes.size()]));
                List<Afternew> afternews = MergeEntitySchema.combineArrays(baseScripts.getAfternew(), derivedScripts.getAfternew());
                resultScripts.setAfternew(afternews.toArray(new Afternew[afternews.size()]));
                List<Afterupdate> afterupdates = MergeEntitySchema.combineArrays(baseScripts.getAfterupdate(), derivedScripts.getAfterupdate());
                resultScripts.setAfterupdate(afterupdates.toArray(new Afterupdate[afterupdates.size()]));
                List<Beforedelete> beforedeletes = MergeEntitySchema.combineArrays(baseScripts.getBeforedelete(), derivedScripts.getBeforedelete());
                resultScripts.setBeforedelete(beforedeletes.toArray(new Beforedelete[beforedeletes.size()]));
                List<Beforeupdate> beforeupdates = MergeEntitySchema.combineArrays(baseScripts.getBeforeupdate(), derivedScripts.getBeforeupdate());
                resultScripts.setBeforeupdate(beforeupdates.toArray(new Beforeupdate[beforeupdates.size()]));
                Update baseUpdate = baseScripts.getUpdate();
                Update derUpdate = derivedScripts.getUpdate();
                if (baseUpdate != null && derUpdate != null) {
                    logger.log(Level.WARNING, "Couldn't replace update script [" + baseUpdate.getName() + "] with [" + derUpdate.getName() + "] in base entity.");
                }
                resultScripts.setUpdate(baseUpdate != null ? baseUpdate : derUpdate);
                Delete baseDelete = baseScripts.getDelete();
                Delete derDelete = derivedScripts.getDelete();
                if (baseDelete != null && derDelete != null) {
                    logger.log(Level.WARNING, "Couldn't replace delete script [" + baseDelete.getName() + "] with [" + derDelete.getName() + "] in base entity.");
                }
                resultScripts.setDelete(baseDelete != null ? baseDelete : derDelete);
            }
        } else {
            resultScripts = derivedScripts;
        }
        return resultScripts;
    }

    private static <T> List<T> combineArrays(T[] array1, T[] array2) {
        LinkedList<T> resultArray = new LinkedList<T>();
        for (T value : array1) {
            resultArray.add(value);
        }
        for (T value : array2) {
            resultArray.add(value);
        }
        return resultArray;
    }
}

