/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.ApplicationBuilder;
import com.queplix.ant.MergeChainsSchema;
import com.queplix.ant.MergeContextMenuSchema;
import com.queplix.ant.MergeCustomSchema;
import com.queplix.ant.MergeDBSchema;
import com.queplix.ant.MergeDataShema;
import com.queplix.ant.MergeEntitySchema;
import com.queplix.ant.MergeFocusesSchema;
import com.queplix.ant.MergeMessagesSchema;
import com.queplix.ant.MergePortalConfigSchema;
import com.queplix.ant.QApplication;
import com.queplix.ant.XMLObjectsIO;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class MergeXmlMetaTask
extends Task {
    public static final String VENDOR_DIVIDER_CHAR = ";";
    private String qApplicationDir;
    private String destDir;
    private String dbVendorNames;

    public void execute() throws BuildException {
        if (this.qApplicationDir == null) {
            throw new BuildException("You shall specify qapplication directory.");
        }
        if (this.destDir == null) {
            throw new BuildException("You shall specify destination directory.");
        }
        XMLObjectsIO.clearDestDirectory(this.destDir);
        QApplication application = ApplicationBuilder.buildApplication(this.qApplicationDir);
        MergeDBSchema.mergeDBSchema(application);
        MergeEntitySchema.mergeEntitySchema(application);
        MergeChainsSchema.mergeChainsSchema(application);
        MergeDataShema.mergeDataSchema(application);
        MergeCustomSchema.mergeCustomSchema(application);
        MergeMessagesSchema.mergeMessages(application);
        MergeFocusesSchema.mergeFocusesSchema(application);
        MergePortalConfigSchema.mergePortalConfigsSchema(application);
        MergeContextMenuSchema.mergeContextMenuSchema(application);
        XMLObjectsIO.writeApplicationConfig(application, this.destDir);
        try {
            if (this.dbVendorNames != null && !"".equalsIgnoreCase(this.dbVendorNames)) {
                XMLObjectsIO.copyResources(application, this.qApplicationDir, this.destDir, this.dbVendorNames.split(VENDOR_DIVIDER_CHAR));
            } else {
                XMLObjectsIO.copyResources(application, this.qApplicationDir, this.destDir);
            }
        }
        catch (IOException e) {
            throw new BuildException("Could not copy resources.", (Throwable)e);
        }
    }

    public String getQApplicationDir() {
        return this.qApplicationDir;
    }

    public void setQApplicationDir(String qApplicationDir) {
        this.qApplicationDir = qApplicationDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public String getDbVendorNames() {
        return this.dbVendorNames;
    }

    public void setDbVendorNames(String dbVendorNames) {
        this.dbVendorNames = dbVendorNames;
    }

    public static void main(String[] args) {
        MergeXmlMetaTask task = new MergeXmlMetaTask();
        task.setQApplicationDir("C:\\Projects\\queplix3.0\\app\\qwoss\\trunk\\qwoss\\misc\\");
        task.setDestDir("C:\\Projects\\queplix3.0\\app\\qwoss\\trunk\\qwoss\\result\\");
        task.execute();
    }
}

