/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.CyclicDependencyFoundException;
import com.queplix.ant.QModule;
import com.queplix.contextmenu.ContextMenus;
import com.queplix.custom.Customs;
import com.queplix.dbschema.DbSchema;
import com.queplix.entity.Chains;
import com.queplix.entity.Dataschemas;
import com.queplix.entity.EntityConfig;
import com.queplix.focus.Focus;
import com.queplix.messages.Messages;
import com.queplix.portal.PortalConfigs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class QApplication
implements Comparator<String> {
    private Map<String, QModule> qModules;
    private List<String> naturalModulesOrder;
    private Set<String> dependecyModulesOrder;
    private DbSchema contributedDBSchema = new DbSchema();
    private EntityConfig contributedEntityConfig = new EntityConfig();
    private Chains contributedChains = new Chains();
    private Dataschemas contributedDataschemas = new Dataschemas();
    private Customs contributedCustomNames = new Customs();
    private Messages contributedMessages = new Messages();
    private List<Focus> contributedFocuses = new ArrayList<Focus>();
    private ContextMenus contributedContextMenus = new ContextMenus();
    private PortalConfigs contributedPortalConfigs = new PortalConfigs();

    public QApplication(Map<String, QModule> qModules, List<String> naturalModulesOrder) {
        this.naturalModulesOrder = naturalModulesOrder;
        if (qModules == null) {
            throw new IllegalArgumentException("Modules map could not be null object.");
        }
        this.qModules = qModules;
        this.dependecyModulesOrder = new TreeSet<String>(this);
        for (String moduleName : qModules.keySet()) {
            this.dependecyModulesOrder.add(moduleName);
        }
    }

    public Map<String, QModule> getQModules() {
        return Collections.unmodifiableMap(this.qModules);
    }

    public Set<String> getDependecyModulesOrder() {
        return Collections.unmodifiableSet(this.dependecyModulesOrder);
    }

    public int depend(QModule first, QModule second) throws CyclicDependencyFoundException {
        if (first == null || second == null) {
            throw new IllegalArgumentException("Each comparing module should be not null object.");
        }
        if (first.getName().equalsIgnoreCase(second.getName())) {
            throw new IllegalArgumentException("Should be distinct nodes.");
        }
        boolean firstDepend = QApplication.depend(second, first, new HashSet<String>());
        boolean secondDepend = QApplication.depend(first, second, new HashSet<String>());
        if (firstDepend && secondDepend) {
            CyclicDependencyFoundException foundException = new CyclicDependencyFoundException();
            foundException.addCyclicModule(first.getName());
            foundException.addCyclicModule(second.getName());
            throw foundException;
        }
        if (firstDepend) {
            return 1;
        }
        if (secondDepend) {
            return -1;
        }
        return 0;
    }

    private static boolean depend(QModule targetModule, QModule thisModule, Set<String> passedModules) {
        Collection<QModule> dependsOn = thisModule.getDependsOn();
        if (passedModules.contains(thisModule.getName())) {
            CyclicDependencyFoundException foundException = new CyclicDependencyFoundException();
            foundException.addCyclicModule(thisModule.getName());
            throw foundException;
        }
        if (thisModule.getName().equalsIgnoreCase(targetModule.getName())) {
            return true;
        }
        passedModules.add(thisModule.getName());
        for (QModule module : dependsOn) {
            HashSet<String> each;
            boolean depend = QApplication.depend(targetModule, module, each = new HashSet<String>(passedModules));
            if (!depend) continue;
            return true;
        }
        return false;
    }

    public List<String> getNaturalModulesOrder() {
        return Collections.unmodifiableList(this.naturalModulesOrder);
    }

    public int getModulesOrder(QModule first, QModule second) throws CyclicDependencyFoundException {
        int ret;
        int deps = this.depend(first, second);
        if (deps == 0) {
            int firstIdx = this.naturalModulesOrder.indexOf(first.getName());
            int secondIdx = this.naturalModulesOrder.indexOf(second.getName());
            ret = firstIdx - secondIdx;
        } else {
            ret = deps;
        }
        return ret;
    }

    public DbSchema getContributedDBSchema() {
        return this.contributedDBSchema;
    }

    public void setContributedDBSchema(DbSchema contributedDBSchema) {
        this.contributedDBSchema = contributedDBSchema;
    }

    public EntityConfig getContributedEntityConfig() {
        return this.contributedEntityConfig;
    }

    public void setContributedEntityConfig(EntityConfig contributedEntityConfig) {
        this.contributedEntityConfig = contributedEntityConfig;
    }

    public Chains getContributedChains() {
        return this.contributedChains;
    }

    public void setContributedChains(Chains contributedChains) {
        this.contributedChains = contributedChains;
    }

    public Dataschemas getContributedDataschemas() {
        return this.contributedDataschemas;
    }

    public void setContributedDataschemas(Dataschemas contributedDataschemas) {
        this.contributedDataschemas = contributedDataschemas;
    }

    public Customs getContributedCustomNames() {
        return this.contributedCustomNames;
    }

    public void setContributedCustomNames(Customs contributedCustomNames) {
        this.contributedCustomNames = contributedCustomNames;
    }

    public Messages getContributedMessages() {
        return this.contributedMessages;
    }

    public void setContributedMessages(Messages contributedMessages) {
        this.contributedMessages = contributedMessages;
    }

    public List<Focus> getContributedFocuses() {
        return this.contributedFocuses;
    }

    public void setContributedFocuses(List<Focus> contributedFocuses) {
        this.contributedFocuses = contributedFocuses;
    }

    public ContextMenus getContributedContextMenus() {
        return this.contributedContextMenus;
    }

    public void setContributedContextMenus(ContextMenus contributedContextMenus) {
        this.contributedContextMenus = contributedContextMenus;
    }

    public PortalConfigs getContributedPortalConfigs() {
        return this.contributedPortalConfigs;
    }

    public void setContributedPortalConfigs(PortalConfigs contributedPortalConfigs) {
        this.contributedPortalConfigs = contributedPortalConfigs;
    }

    @Override
    public int compare(String o1, String o2) {
        QModule first = this.qModules.get(o1);
        QModule second = this.qModules.get(o2);
        return this.getModulesOrder(first, second);
    }
}

