/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.ant;

import com.queplix.ant.FileUtil;
import com.queplix.ant.QApplication;
import com.queplix.ant.QModule;
import com.queplix.contextmenu.ContextMenu;
import com.queplix.contextmenu.ContextMenus;
import com.queplix.custom.Custom;
import com.queplix.custom.Customs;
import com.queplix.dbschema.DbSchema;
import com.queplix.dbschema.Script;
import com.queplix.entity.Chain;
import com.queplix.entity.Chains;
import com.queplix.entity.Dataschema;
import com.queplix.entity.Dataschemas;
import com.queplix.entity.Entity;
import com.queplix.entity.EntityConfig;
import com.queplix.focus.Focus;
import com.queplix.messages.Messages;
import com.queplix.messages.Server;
import com.queplix.portal.PortalConfigs;
import com.queplix.qmodule.QapplicationConfig;
import com.queplix.qmodule.QmoduleConfig;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;

class XMLObjectsIO {
    public static final Logger logger = Logger.getLogger("global");
    public static final String DRIVE_CLASS_POSTFIX = "Descriptor";
    public static final String XML_FILES_EXTENSION = ".xml";
    public static final String APPLICATION_FILE_NAME = "qapplication-descriptor.xml";
    public static final String MODULE_FILE_NAME = "qmodule-descriptor.xml";
    public static final String PORTAL_CONFIG_FILE_NAME = "portal-config.xml";
    public static final String DB_SCHEMA_FILE_NAME = "db_schema.xml";
    public static final String CHAINS_FILE_NAME = "chains.xml";
    public static final String DATASCHEMA_FILE_NAME = "dataschema.xml";
    public static final String MESSAGES_FILE_NAME = "server_messages.xml";
    public static final String MODULE_META_SUBDIR_NAME = "qmodule-build";
    public static final String DB_SCHEMA_SUBDIR_NAME = "db_schema";
    public static final String XML_META_SUBDIR_NAME = "xmlmeta";
    public static final String ENTITY_META_SUBDIR_NAME = "entity";
    public static final String CUSTOM_META_SUBDIR_NAME = "custom";
    public static final String FOCUSES_META_SUBDIR_NAME = "form";
    public static final String CONTEXT_MENU_META_SUBDIR_NAME = "context-menu";
    public static final String MESSAGES_META_SUBDIR_NAME = "i18n";
    public static final String CHAIN_META_SUBDIR_NAME = "chain";
    public static final String DATASCHEMA_META_SUBDIR_NAME = "dataschema";
    public static final String CHARTS_META_SUBDIR_NAME = "chart";
    public static final String SCRIPT_FILE_EXTENSION = "sql";
    public static final String[] DB_VENDOR_NAMES = new String[]{"mssql", "mysql", "oracle"};

    XMLObjectsIO() {
    }

    public static Object loadObject(File file, Class cls) {
        try {
            FileReader reader = new FileReader(file);
            Unmarshaller unmarshaller = new Unmarshaller(cls);
            return unmarshaller.unmarshal((Reader)reader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read file: " + file.getAbsolutePath(), e);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException("File is not valid: " + file.getAbsolutePath(), e);
        }
        catch (MarshalException e) {
            throw new IllegalArgumentException("Could not load object from xml file: " + file.getAbsolutePath(), e);
        }
    }

    public static void writeObject(File file, Object object) {
        try {
            FileWriter writer = new FileWriter(file);
            Marshaller.marshal((Object)object, (Writer)writer);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not write file.", e);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException("Output object is not valid.", e);
        }
        catch (MarshalException e) {
            throw new IllegalArgumentException("Could not write object to xml file.", e);
        }
    }

    public static QapplicationConfig loadApplication(String applicationDirectory) {
        File applicationFile = new File(applicationDirectory, APPLICATION_FILE_NAME);
        logger.log(Level.INFO, "Load application config from [" + applicationFile.getAbsolutePath() + "].");
        return (QapplicationConfig)XMLObjectsIO.loadObject(applicationFile, QapplicationConfig.class);
    }

    public static QmoduleConfig loadQModule(String moduleDirectory) {
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File moduleFile = new File(metaDir, MODULE_FILE_NAME);
        logger.log(Level.INFO, "Load qmodule config from [" + moduleFile.getAbsolutePath() + "].");
        return (QmoduleConfig)XMLObjectsIO.loadObject(moduleFile, QmoduleConfig.class);
    }

    public static DbSchema loadDBSchema(String moduleDirectory) {
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File dbschemaDir = new File(metaDir, DB_SCHEMA_SUBDIR_NAME);
        File dbschemaFile = new File(dbschemaDir, DB_SCHEMA_FILE_NAME);
        logger.log(Level.INFO, "Load DB schema from [" + dbschemaFile.getAbsolutePath() + "] file.");
        return (DbSchema)XMLObjectsIO.loadObject(dbschemaFile, DbSchema.class);
    }

    public static EntityConfig loadEntitySchema(String moduleDirectory) {
        File[] configFiles;
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File entitySchemaDir = new File(metaDir, XML_META_SUBDIR_NAME + File.separator + ENTITY_META_SUBDIR_NAME);
        logger.log(Level.INFO, "Load entities schema from xml files located in [" + entitySchemaDir.getAbsolutePath() + "] directory.");
        EntityConfig resultCfg = new EntityConfig();
        for (File configFile : configFiles = entitySchemaDir.listFiles(new XmlFilenameFilter())) {
            Entity[] entities;
            EntityConfig entityCfg = (EntityConfig)XMLObjectsIO.loadObject(configFile, EntityConfig.class);
            for (Entity entity : entities = entityCfg.getEntity()) {
                resultCfg.addEntity(entity);
            }
        }
        return resultCfg;
    }

    public static Chains loadChains(String moduleDirectory) {
        File[] configFiles;
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File chainsSchemaDir = new File(metaDir, XML_META_SUBDIR_NAME + File.separator + ENTITY_META_SUBDIR_NAME + File.separator + CHAIN_META_SUBDIR_NAME);
        logger.log(Level.INFO, "Load chains schema from xml files located in [" + chainsSchemaDir.getAbsolutePath() + "] directory.");
        Chains resultChains = new Chains();
        for (File configFile : configFiles = chainsSchemaDir.listFiles(new XmlFilenameFilter())) {
            Chain[] chains;
            Chains chainCfg = (Chains)XMLObjectsIO.loadObject(configFile, Chains.class);
            for (Chain chain : chains = chainCfg.getChain()) {
                resultChains.addChain(chain);
            }
        }
        return resultChains;
    }

    public static Dataschemas loadDataschemas(String moduleDirectory) {
        File[] configFiles;
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File dataschemaDir = new File(metaDir, XML_META_SUBDIR_NAME + File.separator + ENTITY_META_SUBDIR_NAME + File.separator + DATASCHEMA_META_SUBDIR_NAME);
        logger.log(Level.INFO, "Load data schema from xml files located in [" + dataschemaDir.getAbsolutePath() + "] directory.");
        Dataschemas resultDataschemas = new Dataschemas();
        for (File configFile : configFiles = dataschemaDir.listFiles(new XmlFilenameFilter())) {
            Dataschema[] dataschemas;
            Dataschemas dataschemaCfg = (Dataschemas)XMLObjectsIO.loadObject(configFile, Dataschemas.class);
            for (Dataschema dataschema : dataschemas = dataschemaCfg.getDataschema()) {
                resultDataschemas.addDataschema(dataschema);
            }
        }
        return resultDataschemas;
    }

    public static Customs loadCustomNames(String moduleDirectory) {
        File[] configFiles;
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File customschemaDir = new File(metaDir, XML_META_SUBDIR_NAME + File.separator + CUSTOM_META_SUBDIR_NAME);
        logger.log(Level.INFO, "Load internalization captions schema from xml files located in [" + customschemaDir.getAbsolutePath() + "] directory.");
        Customs resultCustoms = new Customs();
        for (File configFile : configFiles = customschemaDir.listFiles(new XmlFilenameFilter())) {
            Custom[] customs;
            Customs customCfg = (Customs)XMLObjectsIO.loadObject(configFile, Customs.class);
            for (Custom custom : customs = customCfg.getCustom()) {
                resultCustoms.addCustom(custom);
            }
        }
        return resultCustoms;
    }

    public static Messages loadMessages(String moduleDirectory) {
        File[] configFiles;
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File customschemaDir = new File(metaDir, XML_META_SUBDIR_NAME + File.separator + CUSTOM_META_SUBDIR_NAME + File.separator + MESSAGES_META_SUBDIR_NAME);
        logger.log(Level.INFO, "Load internalization server messages schema from xml files located in [" + customschemaDir.getAbsolutePath() + "] directory.");
        Messages resultMessages = new Messages();
        for (File configFile : configFiles = customschemaDir.listFiles(new XmlFilenameFilter())) {
            Server[] serverMessages;
            Messages messagesCfg = (Messages)XMLObjectsIO.loadObject(configFile, Messages.class);
            for (Server message : serverMessages = messagesCfg.getServer()) {
                resultMessages.addServer(message);
            }
        }
        return resultMessages;
    }

    public static List<Focus> loadFocuses(String moduleDirectory) {
        File[] configFiles;
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File formsSchemaDir = new File(metaDir, XML_META_SUBDIR_NAME + File.separator + FOCUSES_META_SUBDIR_NAME);
        logger.log(Level.INFO, "Load focuses schema from xml files located in [" + formsSchemaDir.getAbsolutePath() + "] directory.");
        LinkedList<Focus> resultFocuses = new LinkedList<Focus>();
        for (File configFile : configFiles = formsSchemaDir.listFiles(new XmlFilenameFilter())) {
            Focus focusCfg = (Focus)XMLObjectsIO.loadObject(configFile, Focus.class);
            resultFocuses.add(focusCfg);
        }
        return resultFocuses;
    }

    public static ContextMenus loadContextMenus(String moduleDirectory) {
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File contextMenusDir = new File(metaDir, XML_META_SUBDIR_NAME + File.separator + FOCUSES_META_SUBDIR_NAME + File.separator + CONTEXT_MENU_META_SUBDIR_NAME);
        logger.log(Level.INFO, "Load forms context menu schema from xml files located in [" + contextMenusDir.getAbsolutePath() + "] directory.");
        ContextMenus resultMenus = new ContextMenus();
        if (contextMenusDir.exists()) {
            File[] configFiles;
            for (File configFile : configFiles = contextMenusDir.listFiles(new XmlFilenameFilter())) {
                ContextMenu[] menus;
                ContextMenus menusCfgs = (ContextMenus)XMLObjectsIO.loadObject(configFile, ContextMenus.class);
                for (ContextMenu menu : menus = menusCfgs.getContextMenu()) {
                    resultMenus.addContextMenu(menu);
                }
            }
        }
        return resultMenus;
    }

    public static PortalConfigs loadPortalConfigs(String moduleDirectory) {
        File metaDir = new File(moduleDirectory, MODULE_META_SUBDIR_NAME);
        File portalConfigFile = new File(metaDir, XML_META_SUBDIR_NAME + File.separator + PORTAL_CONFIG_FILE_NAME);
        logger.log(Level.INFO, "Load portal config schema from [" + portalConfigFile.getAbsolutePath() + "] file.");
        PortalConfigs ret = portalConfigFile.exists() ? (PortalConfigs)XMLObjectsIO.loadObject(portalConfigFile, PortalConfigs.class) : new PortalConfigs();
        return ret;
    }

    public static void writeApplicationConfig(QApplication application, String destDir) {
        logger.log(Level.INFO, "Write application contributed metadata to [" + destDir + "] directory.");
        File outDirFile = new File(destDir);
        XMLObjectsIO.createIfNotExists(outDirFile);
        File outDBSchemaDir = new File(outDirFile, DB_SCHEMA_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outDBSchemaDir);
        File outXmlmetaDir = new File(outDirFile, XML_META_SUBDIR_NAME);
        File outEntityDir = new File(outXmlmetaDir, ENTITY_META_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outEntityDir);
        File outChainDir = new File(outEntityDir, CHAIN_META_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outChainDir);
        File outDataSchemaDir = new File(outEntityDir, DATASCHEMA_META_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outDataSchemaDir);
        File outCustomDir = new File(outXmlmetaDir, CUSTOM_META_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outCustomDir);
        File outMessagesDir = new File(outCustomDir, MESSAGES_META_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outMessagesDir);
        File outFocusesDir = new File(outXmlmetaDir, FOCUSES_META_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outFocusesDir);
        File outContextMenuDir = new File(outFocusesDir, CONTEXT_MENU_META_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outContextMenuDir);
        File outDBSchemaFile = new File(outDBSchemaDir, DB_SCHEMA_FILE_NAME);
        logger.log(Level.INFO, "Write database metadata to [" + outDBSchemaFile.getAbsolutePath() + "] file.");
        XMLObjectsIO.writeObject(outDBSchemaFile, application.getContributedDBSchema());
        logger.log(Level.INFO, "Write entities metadata to [" + outEntityDir.getAbsolutePath() + "] directory.");
        EntityConfig cfg = application.getContributedEntityConfig();
        Entity[] entities = cfg.getEntity();
        EntityConfig toWrite = new EntityConfig();
        for (Entity entity : entities) {
            toWrite.setEntity(new Entity[]{entity});
            XMLObjectsIO.writeObject(new File(outEntityDir, entity.getName() + XML_FILES_EXTENSION), toWrite);
        }
        logger.log(Level.INFO, "Write chains metadata to [" + outChainDir.getAbsolutePath() + "] directory.");
        Chains chains = application.getContributedChains();
        XMLObjectsIO.writeObject(new File(outChainDir, CHAINS_FILE_NAME), chains);
        logger.log(Level.INFO, "Write data metadata to [" + outDataSchemaDir.getAbsolutePath() + "] directory.");
        Dataschemas dataschemas = application.getContributedDataschemas();
        XMLObjectsIO.writeObject(new File(outDataSchemaDir, DATASCHEMA_FILE_NAME), dataschemas);
        logger.log(Level.INFO, "Write chains metadata to [" + outChainDir.getAbsolutePath() + "] directory.");
        Customs customs = application.getContributedCustomNames();
        Custom[] customServerMessages = customs.getCustom();
        Customs customsToWrite = new Customs();
        for (Custom custom : customServerMessages) {
            customsToWrite.setCustom(new Custom[]{custom});
            XMLObjectsIO.writeObject(new File(outCustomDir, custom.getEntity() + XML_FILES_EXTENSION), customsToWrite);
        }
        logger.log(Level.INFO, "Write internalization captions metadata to [" + outMessagesDir.getAbsolutePath() + "] directory.");
        Messages messages = application.getContributedMessages();
        XMLObjectsIO.writeObject(new File(outMessagesDir, MESSAGES_FILE_NAME), messages);
        logger.log(Level.INFO, "Write focuses metadata to [" + outFocusesDir.getAbsolutePath() + "] directory.");
        List<Focus> focuses = application.getContributedFocuses();
        int counter = 0;
        for (Focus focus : focuses) {
            XMLObjectsIO.writeObject(new File(outFocusesDir, counter + "_" + focus.getName() + XML_FILES_EXTENSION), focus);
            ++counter;
        }
        logger.log(Level.INFO, "Write context metadata to [" + outContextMenuDir.getAbsolutePath() + "] directory.");
        ContextMenus menusCfg = application.getContributedContextMenus();
        ContextMenu[] menus = menusCfg.getContextMenu();
        ContextMenus contextMenuToWrite = new ContextMenus();
        for (ContextMenu menu : menus) {
            contextMenuToWrite.setContextMenu(new ContextMenu[]{menu});
            XMLObjectsIO.writeObject(new File(outContextMenuDir, menu.getName() + XML_FILES_EXTENSION), contextMenuToWrite);
        }
        logger.log(Level.INFO, "Write portal config metadata to [" + outXmlmetaDir.getAbsolutePath() + "] directory.");
        PortalConfigs portalCfg = application.getContributedPortalConfigs();
        XMLObjectsIO.writeObject(new File(outXmlmetaDir, PORTAL_CONFIG_FILE_NAME), portalCfg);
    }

    private static void createIfNotExists(File outDirFile) {
        if (!outDirFile.exists() && !outDirFile.mkdirs()) {
            throw new IllegalStateException("Could not create directory [" + outDirFile.getAbsolutePath() + "].");
        }
    }

    public static void copyResources(QApplication application, String qApplicationDirectory, String destDir) throws IOException {
        XMLObjectsIO.copyResources(application, qApplicationDirectory, destDir, DB_VENDOR_NAMES);
    }

    public static void copyResources(QApplication application, String qApplicationDirectory, String destDir, String[] vendorNames) throws IOException {
        logger.log(Level.INFO, "Copy other qmodules resources.");
        File outDirFile = new File(destDir);
        XMLObjectsIO.createIfNotExists(outDirFile);
        File outDBSchemaDir = new File(outDirFile, DB_SCHEMA_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outDBSchemaDir);
        File outXmlMetaDir = new File(outDirFile, XML_META_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outXmlMetaDir);
        File outChartDir = new File(outXmlMetaDir, CHARTS_META_SUBDIR_NAME);
        XMLObjectsIO.createIfNotExists(outChartDir);
        Set<String> moduleNames = application.getDependecyModulesOrder();
        Map<String, QModule> modules = application.getQModules();
        for (String moduleName : moduleNames) {
            DbSchema schema;
            QModule module = modules.get(moduleName);
            String absoluteModuleDir = new File(qApplicationDirectory, module.getDir()).getAbsolutePath();
            File metaDir = new File(absoluteModuleDir, MODULE_META_SUBDIR_NAME);
            File dbschemaDir = new File(metaDir, DB_SCHEMA_SUBDIR_NAME);
            File chartsSourceDir = new File(metaDir, XML_META_SUBDIR_NAME + File.separator + CHARTS_META_SUBDIR_NAME);
            if (chartsSourceDir.exists()) {
                XMLObjectsIO.copyCharts(chartsSourceDir, outChartDir);
            }
            if ((schema = module.getDbSchema()) == null) continue;
            XMLObjectsIO.copyCustomScripts(schema.getCustom(), outDBSchemaDir, dbschemaDir, vendorNames);
        }
    }

    private static void copyCharts(File chartsSourceDir, File outChartDir) throws IOException {
        File[] chartFiles;
        for (File chartFile : chartFiles = chartsSourceDir.listFiles(new XmlFilenameFilter())) {
            FileUtil.copyFile(chartFile, new File(outChartDir, chartFile.getName()));
        }
    }

    private static void copyCustomScripts(com.queplix.dbschema.Custom custom, File outDBSchemaDir, File inDBSchemaDir, String[] vendorNames) throws IOException {
        String[] guids;
        Script script;
        if (custom != null && (script = custom.getScript()) != null && (guids = script.getGuid()) != null) {
            ScriptsGUIDFilenameFilter filter = new ScriptsGUIDFilenameFilter(guids);
            for (String vendorName : vendorNames) {
                File inVendorNameDir = new File(inDBSchemaDir, vendorName);
                File[] filesToCopy = inVendorNameDir.listFiles(filter);
                if (filesToCopy == null || filesToCopy.length <= 0) continue;
                File outVendorNameDir = new File(outDBSchemaDir, vendorName);
                XMLObjectsIO.createIfNotExists(outVendorNameDir);
                for (File file : filesToCopy) {
                    FileUtil.copyFile(file, new File(outVendorNameDir, file.getName()));
                }
            }
        }
    }

    public static <T> T cloneXMLObject(T src) {
        Object dest;
        Class<?> cl = src.getClass();
        try {
            Object srcObj;
            XMLFieldDescriptor fieldDescr;
            dest = cl.newInstance();
            if (cl.equals(String.class)) {
                return src;
            }
            Class descrClass = XMLObjectsIO.getFieldDescriptorClass(cl);
            XMLClassDescriptor classDescr = (XMLClassDescriptor)descrClass.newInstance();
            XMLFieldDescriptor[] fieldDescrs = classDescr.getAttributeDescriptors();
            if (fieldDescrs != null) {
                for (XMLFieldDescriptor fieldDescr2 : fieldDescrs) {
                    Object srcObj2 = fieldDescr2.getHandler().getValue(src);
                    if (srcObj2 == null) continue;
                    fieldDescr2.getHandler().setValue(dest, srcObj2);
                }
            }
            if ((fieldDescrs = classDescr.getElementDescriptors()) != null) {
                for (XMLFieldDescriptor fieldDescr2 : fieldDescrs) {
                    Object child = fieldDescr2.getHandler().getValue(src);
                    FieldHandler fieldHnd = fieldDescr2.getHandler();
                    if (fieldDescr2.isMultivalued()) {
                        Object[] childs;
                        for (Object child1 : childs = (Object[])child) {
                            if (child1 == null) continue;
                            fieldHnd.setValue(dest, XMLObjectsIO.cloneXMLObject(child1));
                        }
                        continue;
                    }
                    if (child == null) continue;
                    fieldHnd.setValue(dest, XMLObjectsIO.cloneXMLObject(child));
                }
            }
            if ((fieldDescr = classDescr.getContentDescriptor()) != null && (srcObj = fieldDescr.getHandler().getValue(src)) != null) {
                fieldDescr.getHandler().setValue(dest, srcObj);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot clone object.", ex);
        }
        return (T)dest;
    }

    private static Class getFieldDescriptorClass(Class fieldClass) throws ClassNotFoundException {
        return Class.forName(fieldClass.getName() + DRIVE_CLASS_POSTFIX);
    }

    public static void clearDestDirectory(String destDir) {
        File path = new File(destDir);
        logger.log(Level.INFO, "Clear destination directory [" + path.getAbsolutePath() + "].");
        XMLObjectsIO.deleteDirectory(new File(path, XML_META_SUBDIR_NAME));
        XMLObjectsIO.deleteDirectory(new File(path, DB_SCHEMA_SUBDIR_NAME));
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    XMLObjectsIO.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }

    private static class ScriptsGUIDFilenameFilter
    implements FilenameFilter {
        private Set<String> scriptNames = new TreeSet<String>();

        public ScriptsGUIDFilenameFilter(String[] scriptNames) {
            for (String scriptName : scriptNames) {
                this.scriptNames.add(scriptName + "." + XMLObjectsIO.SCRIPT_FILE_EXTENSION);
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            return this.scriptNames.contains(name);
        }
    }

    private static class XmlFilenameFilter
    implements FileFilter {
        private XmlFilenameFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return !pathname.isDirectory() && pathname.getAbsolutePath().endsWith(XMLObjectsIO.XML_FILES_EXTENSION);
        }
    }
}

