/*
 * Decompiled with CFR 0.152.
 */
package com.queplix.dbschema;

import com.queplix.dbschema.Cluster;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class View
implements Serializable {
    private String _name;
    private ArrayList _clusterList = new ArrayList();

    public void addCluster(Cluster vCluster) throws IndexOutOfBoundsException {
        this._clusterList.add(vCluster);
    }

    public void addCluster(int index, Cluster vCluster) throws IndexOutOfBoundsException {
        this._clusterList.add(index, vCluster);
    }

    public void clearCluster() {
        this._clusterList.clear();
    }

    public Enumeration enumerateCluster() {
        return new IteratorEnumeration(this._clusterList.iterator());
    }

    public Cluster getCluster(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._clusterList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Cluster)this._clusterList.get(index);
    }

    public Cluster[] getCluster() {
        int size = this._clusterList.size();
        Cluster[] mArray = new Cluster[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Cluster)this._clusterList.get(index);
        }
        return mArray;
    }

    public int getClusterCount() {
        return this._clusterList.size();
    }

    public String getName() {
        return this._name;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeCluster(Cluster vCluster) {
        boolean removed = this._clusterList.remove(vCluster);
        return removed;
    }

    public void setCluster(int index, Cluster vCluster) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._clusterList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._clusterList.set(index, vCluster);
    }

    public void setCluster(Cluster[] clusterArray) {
        this._clusterList.clear();
        for (int i = 0; i < clusterArray.length; ++i) {
            this._clusterList.add(clusterArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (View)Unmarshaller.unmarshal(View.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

